/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.AerialInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.UniversalSensorBlockEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pneumaticcraft")
public class GlobalBlockEntityCacheManager {
    private static final GlobalBlockEntityCacheManager CLIENT_INSTANCE = new GlobalBlockEntityCacheManager();
    private static final GlobalBlockEntityCacheManager SERVER_INSTANCE = new GlobalBlockEntityCacheManager();
    private final GlobalTileEntityCache<UniversalSensorBlockEntity> universalSensors = new GlobalTileEntityCache();
    private final GlobalTileEntityCache<ChargingStationBlockEntity> chargingStations = new GlobalTileEntityCache();
    private final GlobalTileEntityCache<SecurityStationBlockEntity> securityStations = new GlobalTileEntityCache();
    private final GlobalTileEntityCache<AerialInterfaceBlockEntity> aerialInterfaces = new GlobalTileEntityCache();

    private void removeFromWorld(LevelAccessor level) {
        this.universalSensors.removeFromWorld(level);
        this.chargingStations.removeFromWorld(level);
        this.securityStations.removeFromWorld(level);
        this.aerialInterfaces.removeFromWorld(level);
    }

    public static GlobalBlockEntityCacheManager getInstance(@Nullable LevelAccessor level) {
        return level != null && level.m_5776_() ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(LevelEvent.Unload event) {
        GlobalBlockEntityCacheManager.getInstance(event.getLevel()).removeFromWorld(event.getLevel());
    }

    public GlobalTileEntityCache<UniversalSensorBlockEntity> getUniversalSensors() {
        return this.universalSensors;
    }

    public GlobalTileEntityCache<ChargingStationBlockEntity> getChargingStations() {
        return this.chargingStations;
    }

    public GlobalTileEntityCache<SecurityStationBlockEntity> getSecurityStations() {
        return this.securityStations;
    }

    public GlobalTileEntityCache<AerialInterfaceBlockEntity> getAerialInterfaces() {
        return this.aerialInterfaces;
    }

    public static class GlobalTileEntityCache<T extends BlockEntity>
    implements Iterable<T> {
        private final Set<T> blockEntities = Collections.newSetFromMap(new WeakHashMap());

        public void add(T blockEntity) {
            this.blockEntities.add(blockEntity);
        }

        public void remove(T blockEntity) {
            this.blockEntities.remove(blockEntity);
        }

        public void removeFromWorld(LevelAccessor world) {
            this.blockEntities.removeIf(be -> be.m_58904_() == world);
        }

        public Stream<T> stream() {
            return this.blockEntities.stream();
        }

        @Override
        public Iterator<T> iterator() {
            return this.blockEntities.iterator();
        }
    }
}

