/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CountedItemStacks
extends Object2IntOpenCustomHashMap<ItemStack> {
    private final boolean canCoalesce;

    public CountedItemStacks() {
        super((Hash.Strategy)new ItemStackHashingStrategy());
        this.canCoalesce = false;
    }

    public CountedItemStacks(IItemHandler handler) {
        super(handler.getSlots(), (Hash.Strategy)new ItemStackHashingStrategy());
        boolean canCoalesce = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int seenAlready = this.getInt(stack);
            if (seenAlready > 0 && seenAlready + stack.m_41613_() <= stack.m_41741_()) {
                canCoalesce = true;
            }
            this.put(stack, seenAlready + stack.m_41613_());
        }
        this.canCoalesce = canCoalesce;
    }

    public boolean canCoalesce() {
        return this.canCoalesce;
    }

    public NonNullList<ItemStack> coalesce() {
        NonNullList coalesced = NonNullList.m_122779_();
        this.forEach((stack, amount) -> {
            while (amount > 0) {
                int toTake = Math.min(amount, stack.m_41741_());
                amount = amount - toTake;
                coalesced.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)toTake));
            }
        });
        return coalesced;
    }

    private static class ItemStackHashingStrategy
    implements Hash.Strategy<ItemStack> {
        private ItemStackHashingStrategy() {
        }

        public int hashCode(ItemStack object) {
            return Objects.hash(object.m_41720_(), object.m_41783_());
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && ItemStack.m_150942_((ItemStack)o1, (ItemStack)o2);
        }
    }
}

