/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class PNCUpgradeImpl
implements PNCUpgrade {
    private static final AtomicInteger ids = new AtomicInteger();
    private final ResourceLocation id;
    private final int maxTier;
    private final List<String> depModIds;
    private final int cacheId;

    PNCUpgradeImpl(ResourceLocation id, int maxTier, String ... depModIds) {
        this.id = id;
        this.maxTier = maxTier;
        this.depModIds = ImmutableList.copyOf((Object[])depModIds);
        this.cacheId = ids.getAndIncrement();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public int getCacheId() {
        return this.cacheId;
    }

    @Override
    public final int getMaxTier() {
        return this.maxTier;
    }

    @Override
    public final boolean isDependencyLoaded() {
        return this.depModIds.isEmpty() || this.depModIds.stream().anyMatch(modid -> ModList.get().isLoaded(modid));
    }

    @Override
    public final ResourceLocation getItemRegistryName(int tier) {
        Validate.isTrue((tier > 0 && tier <= this.maxTier ? 1 : 0) != 0, (String)("tier must be in range 1 .. " + this.maxTier + "!"), (Object[])new Object[0]);
        String path = this.id.m_135815_() + "_upgrade" + (String)(this.maxTier > 1 ? "_" + tier : "");
        return new ResourceLocation(this.id.m_135827_(), path);
    }

    @Override
    public final Item getItem(int tier) {
        return (Item)ForgeRegistries.ITEMS.getValue(this.getItemRegistryName(tier));
    }

    @Override
    public final ItemStack getItemStack(int count) {
        Item item = this.getItem();
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return this.maxTier == 1 ? new ItemStack((ItemLike)item, count) : new ItemStack((ItemLike)this.getItem(count));
    }
}

