/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PlayerFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class AmadronOffer
extends AmadronRecipe {
    @Nonnull
    protected final AmadronTradeResource input;
    @Nonnull
    protected final AmadronTradeResource output;
    protected final PlayerFilter whitelist;
    protected final PlayerFilter blacklist;
    private final boolean isStaticOffer;
    private final int tradeLevel;
    private final int maxStock;
    protected int inStock;
    private boolean isVillagerTrade = false;

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean isStaticOffer, int tradeLevel, int maxStock, int inStock, PlayerFilter whitelist, PlayerFilter blacklist) {
        super(id);
        this.input = Objects.requireNonNull(input).validate();
        this.output = Objects.requireNonNull(output).validate();
        this.isStaticOffer = isStaticOffer;
        this.tradeLevel = tradeLevel;
        this.maxStock = maxStock;
        this.inStock = inStock;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean isStaticOffer, int tradeLevel, int maxStock) {
        this(id, input, output, isStaticOffer, tradeLevel, maxStock, maxStock, PlayerFilter.YES, PlayerFilter.NO);
    }

    @Override
    @Nonnull
    public AmadronTradeResource getInput() {
        return this.input;
    }

    @Override
    @Nonnull
    public AmadronTradeResource getOutput() {
        return this.output;
    }

    @Override
    public boolean isStaticOffer() {
        return this.isStaticOffer;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public AmadronOffer setVillagerTrade() {
        this.isVillagerTrade = true;
        return this;
    }

    public boolean equivalentTo(AmadronPlayerOffer offer) {
        return this.input.equivalentTo(offer.getInput()) && this.output.equivalentTo(offer.getOutput());
    }

    @Override
    public Component getVendorName() {
        return PneumaticCraftUtils.xlate(this.isVillagerTrade ? "pneumaticcraft.gui.amadron.villager" : "pneumaticcraft.gui.amadron", new Object[0]);
    }

    @Override
    public int getStock() {
        return this.inStock;
    }

    @Override
    public void setStock(int inStock) {
        int max;
        int n = max = this.maxStock > 0 ? this.maxStock : Integer.MAX_VALUE;
        if (inStock < 0 || inStock > max) {
            Log.warning("Amadron Offer %s: new stock %d out of range (0,%d) - clamped", this, inStock, this.maxStock);
        }
        this.inStock = Mth.m_14045_((int)inStock, (int)0, (int)max);
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        this.input.writeToBuf(buf);
        this.output.writeToBuf(buf);
        buf.writeBoolean(this.isStaticOffer);
        buf.writeByte(this.tradeLevel);
        buf.m_130130_(this.maxStock);
        buf.m_130130_(this.inStock);
        this.whitelist.toBytes(buf);
        this.blacklist.toBytes(buf);
    }

    public static AmadronRecipe offerFromBuf(ResourceLocation id, FriendlyByteBuf buf) {
        return (AmadronRecipe)((RecipeSerializer)ModRecipeSerializers.AMADRON_OFFERS.get()).m_8005_(id, buf);
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("id", this.m_6423_().toString());
        json.add("input", (JsonElement)this.input.toJson());
        json.add("output", (JsonElement)this.output.toJson());
        json.addProperty("static", Boolean.valueOf(this.isStaticOffer));
        json.addProperty("level", (Number)this.tradeLevel);
        if (this.maxStock > 0) {
            json.addProperty("maxStock", (Number)this.maxStock);
        }
        if (this.whitelist.isReal()) {
            json.add("whitelist", (JsonElement)this.whitelist.toJson());
        }
        if (this.blacklist.isReal()) {
            json.add("blacklist", (JsonElement)this.blacklist.toJson());
        }
        return json;
    }

    public String toString() {
        return String.format("[id = %s, in = %s, out = %s, level = %d, maxStock = %d]", this.m_6423_().toString(), this.input, this.output, this.tradeLevel, this.maxStock);
    }

    public Component getDescription() {
        return Component.m_237113_((String)String.format("[%s -> %s]", this.input, this.output));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronOffer)) {
            return false;
        }
        AmadronOffer that = (AmadronOffer)o;
        return this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.AMADRON_OFFERS.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.AMADRON.get();
    }

    @Override
    public int getMaxStock() {
        return this.maxStock;
    }

    @Override
    public boolean isUsableByPlayer(Player player) {
        return this.whitelist.test(player) && !this.blacklist.test(player);
    }

    @Override
    public void addAvailabilityData(Player player, List<Component> curTip) {
        MutableComponent suffix;
        if (this.whitelist.isReal()) {
            suffix = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.whitelist.matchAll() ? "all" : "any"), new Object[0]);
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.whitelist", new Object[0]).m_130946_(" (").m_7220_((Component)suffix).m_130946_(")").m_130940_(ChatFormatting.GOLD));
            this.whitelist.getDescription(player, curTip);
        }
        if (this.blacklist.isReal()) {
            suffix = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.blacklist.matchAll() ? "all" : "any"), new Object[0]);
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.blacklist", new Object[0]).m_130946_(" (").m_7220_((Component)suffix).m_130946_(")").m_130940_(ChatFormatting.GOLD));
            this.blacklist.getDescription(player, curTip);
        }
    }

    @Override
    public boolean isLocationLimited() {
        return this.whitelist.isReal() || this.blacklist.isReal();
    }

    public static class Serializer<T extends AmadronRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            try {
                int maxStock = GsonHelper.m_13824_((JsonObject)json, (String)"maxStock", (int)-1);
                return this.factory.create(recipeId, AmadronTradeResource.fromJson(json.getAsJsonObject("input")), AmadronTradeResource.fromJson(json.getAsJsonObject("output")), GsonHelper.m_13855_((JsonObject)json, (String)"static", (boolean)true), GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1), maxStock, maxStock, json.has("whitelist") ? PlayerFilter.fromJson(json.getAsJsonObject("whitelist")) : PlayerFilter.YES, json.has("blacklist") ? PlayerFilter.fromJson(json.getAsJsonObject("blacklist")) : PlayerFilter.NO);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return this.factory.create(recipeId, AmadronTradeResource.fromPacketBuf(buffer), AmadronTradeResource.fromPacketBuf(buffer), buffer.readBoolean(), buffer.readByte(), buffer.m_130242_(), buffer.m_130242_(), PlayerFilter.fromBytes(buffer), PlayerFilter.fromBytes(buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends AmadronRecipe> {
            public T create(ResourceLocation var1, AmadronTradeResource var2, AmadronTradeResource var3, boolean var4, int var5, int var6, int var7, PlayerFilter var8, PlayerFilter var9);
        }
    }
}

