/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.gson.JsonObject;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FluidTagPresentCondition
implements ICondition {
    private static final ResourceLocation NAME = PneumaticRegistry.RL("fluid_tag_present");
    private final TagKey<Fluid> tagKey;

    public FluidTagPresentCondition(ResourceLocation tagName) {
        this.tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)tagName);
    }

    public FluidTagPresentCondition(String tagName) {
        this(new ResourceLocation(tagName));
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return !context.getTag(this.tagKey).isEmpty();
    }

    public static class Serializer
    implements IConditionSerializer<FluidTagPresentCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, FluidTagPresentCondition value) {
            json.addProperty("tag", value.tagKey.f_203868_().toString());
        }

        public FluidTagPresentCondition read(JsonObject json) {
            return new FluidTagPresentCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

