/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.UUID;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;

public class StepAssistHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final UUID STEP_ASSIST_MODIFIER_ID = UUID.fromString("30bc8c6e-4f40-41e5-8b11-4001a9a85afb");

    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.STEP_ASSIST;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[0];
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.FEET;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        AttributeInstance attributeInstance = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (attributeInstance != null) {
            double stepBoost;
            AttributeModifier currentModifier = attributeInstance.m_22111_(STEP_ASSIST_MODIFIER_ID);
            double d = stepBoost = enabled && commonArmorHandler.hasMinPressure(EquipmentSlot.FEET) && !player.m_6144_() ? 0.6 : 0.0;
            if (currentModifier != null) {
                if (PneumaticCraftUtils.epsilonEquals(currentModifier.m_22218_(), stepBoost)) {
                    return;
                }
                attributeInstance.m_22130_(currentModifier);
            }
            if (stepBoost > 0.0) {
                attributeInstance.m_22118_(new AttributeModifier(STEP_ASSIST_MODIFIER_ID, "Step Assist", stepBoost, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        AttributeModifier currentModifier;
        AttributeInstance attributeInstance;
        if (!newState && (attributeInstance = commonArmorHandler.getPlayer().m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null && (currentModifier = attributeInstance.m_22111_(STEP_ASSIST_MODIFIER_ID)) != null) {
            attributeInstance.m_22130_(currentModifier);
        }
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        AttributeModifier currentModifier;
        AttributeInstance attributeInstance = commonArmorHandler.getPlayer().m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (attributeInstance != null && (currentModifier = attributeInstance.m_22111_(STEP_ASSIST_MODIFIER_ID)) != null) {
            attributeInstance.m_22130_(currentModifier);
        }
    }
}

