/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class FallProtectionHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.FALL_PROTECTION;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[0];
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.FEET;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerFall(LivingFallEvent event) {
            LivingEntity livingEntity;
            if (event.getDistance() > 3.0f && (livingEntity = event.getEntity()) instanceof Player) {
                Player player = (Player)livingEntity;
                float origDistance = event.getDistance();
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
                if (event.getEntity().m_9236_().m_46791_() == Difficulty.HARD && jbState.isActive()) {
                    event.setDamageMultiplier(0.2f);
                    return;
                }
                if (handler.upgradeUsable(CommonUpgradeHandlers.jumpBoostHandler, true)) {
                    event.setDistance(Math.max(0.0f, event.getDistance() - 1.5f * (float)handler.getUpgradeCount(EquipmentSlot.LEGS, ModUpgrades.JUMPING.get())));
                    if (event.getDistance() < 2.0f) {
                        event.setCanceled(true);
                        return;
                    }
                }
                if (!handler.upgradeUsable(CommonUpgradeHandlers.fallProtectionHandler, true)) {
                    return;
                }
                if (!player.m_9236_().f_46443_) {
                    float airNeeded = event.getDistance() * 20.0f;
                    float extraAirNeeded = 0.0f;
                    int airAvailable = handler.getAir(EquipmentSlot.FEET);
                    ArrayList<Entity> stomped = new ArrayList<Entity>();
                    if (handler.upgradeUsable(CommonUpgradeHandlers.stompHandler, true)) {
                        for (Entity e2 : player.m_9236_().m_6249_((Entity)player, new AABB(player.m_20183_()).m_82400_(7.0), e -> e instanceof Mob && e.m_6084_())) {
                            if (!((float)airAvailable > airNeeded + extraAirNeeded)) break;
                            stomped.add(e2);
                            extraAirNeeded += airNeeded;
                        }
                    }
                    if (airAvailable < 1) {
                        return;
                    }
                    if ((float)airAvailable >= airNeeded + extraAirNeeded) {
                        event.setCanceled(true);
                    } else {
                        event.setDamageMultiplier(1.0f - (float)airAvailable / airNeeded);
                    }
                    int i = 0;
                    while ((float)i < event.getDistance() / 2.0f) {
                        float sx = player.m_217043_().m_188501_() * 0.6f - 0.3f;
                        float sz = player.m_217043_().m_188501_() * 0.6f - 0.3f;
                        NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.m_20185_(), player.m_20186_(), player.m_20189_(), sx, 0.1, sz), player.m_9236_(), player.m_20183_());
                        ++i;
                    }
                    for (Entity e2 : stomped) {
                        NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123813_, e2.m_20185_(), e2.m_20186_(), e2.m_20189_(), 0.0, 0.0, 0.0), player.m_9236_(), player.m_20183_());
                        e2.m_6469_(player.m_269291_().m_269036_((Entity)player, null), Mth.m_14036_((float)(origDistance / 3.0f), (float)1.0f, (float)20.0f));
                    }
                    if (!stomped.isEmpty()) {
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
                    }
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.SHORT_HISS.get(), SoundSource.PLAYERS, 0.3f, 0.8f);
                    handler.addAir(EquipmentSlot.FEET, (int)(-(airNeeded + extraAirNeeded)));
                }
            }
        }
    }
}

