/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.common.block.entity.ReinforcedChestBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public enum BlockTrackLootable {
    INSTANCE;

    private static final List<BiConsumer<Player, BlockEntity>> PREDICATE_LIST;

    void addLootable(BiConsumer<Player, BlockEntity> predicate) {
        PREDICATE_LIST.add(predicate);
    }

    public void apply(Player player, BlockEntity blockEntity) {
        PREDICATE_LIST.forEach(c -> c.accept(player, blockEntity));
    }

    public void addDefaultEntries() {
        this.addLootable((player, blockEntity) -> {
            RandomizableContainerBlockEntity r;
            if (blockEntity instanceof RandomizableContainerBlockEntity && (r = (RandomizableContainerBlockEntity)blockEntity).m_7525_(player)) {
                r.m_59640_(player);
            }
        });
        this.addLootable((player, blockEntity) -> {
            if (blockEntity instanceof ReinforcedChestBlockEntity) {
                ReinforcedChestBlockEntity r = (ReinforcedChestBlockEntity)blockEntity;
                r.maybeFillWithLoot((Player)player);
            }
        });
    }

    static {
        PREDICATE_LIST = new CopyOnWriteArrayList<BiConsumer<Player, BlockEntity>>();
    }
}

