/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdatePressureBlock
extends LocationIntPacket {
    private static final byte NO_DIRECTION = 127;
    private final Direction leakDir;
    private final Direction handlerDir;
    private final int currentAir;

    public PacketUpdatePressureBlock(BlockEntity te, Direction handlerDir, Direction leakDir, int currentAir) {
        super(te.m_58899_());
        this.handlerDir = handlerDir;
        this.leakDir = leakDir;
        this.currentAir = currentAir;
    }

    public PacketUpdatePressureBlock(FriendlyByteBuf buffer) {
        super(buffer);
        this.currentAir = buffer.readInt();
        byte idx = buffer.readByte();
        this.handlerDir = idx >= 0 && idx < 6 ? Direction.m_122376_((int)idx) : null;
        idx = buffer.readByte();
        this.leakDir = idx >= 0 && idx < 6 ? Direction.m_122376_((int)idx) : null;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.currentAir);
        buf.writeByte(this.handlerDir == null ? 127 : this.handlerDir.m_122411_());
        buf.writeByte(this.leakDir == null ? 127 : this.leakDir.m_122411_());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity te = ClientUtils.getBlockEntity(this.pos);
            if (te != null) {
                te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.handlerDir).ifPresent(handler -> {
                    handler.setSideLeaking(this.leakDir);
                    handler.addAir(this.currentAir - handler.getAir());
                    if (this.handlerDir != null && te instanceof AbstractAirHandlingBlockEntity) {
                        ((AbstractAirHandlingBlockEntity)te).initializeHullAirHandlerClient(this.handlerDir, (IAirHandlerMachine)handler);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

