/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncRedstoneModuleToClient
extends LocationIntPacket {
    private final RedstoneModule.EnumRedstoneDirection dir;
    private final int outputLevel;
    private final int inputLevel;
    private final int channel;
    private final Direction side;

    public PacketSyncRedstoneModuleToClient(RedstoneModule module) {
        super(module.getTube().m_58899_());
        this.dir = module.getRedstoneDirection();
        this.outputLevel = module.getRedstoneLevel();
        this.inputLevel = module.getInputLevel();
        this.channel = module.getColorChannel();
        this.side = module.getDirection();
    }

    PacketSyncRedstoneModuleToClient(FriendlyByteBuf buffer) {
        super(buffer);
        this.dir = RedstoneModule.EnumRedstoneDirection.values()[buffer.readByte()];
        this.side = (Direction)buffer.m_130066_(Direction.class);
        this.outputLevel = buffer.readByte();
        this.inputLevel = buffer.readByte();
        this.channel = buffer.readByte();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.dir.ordinal());
        buf.m_130068_((Enum)this.side);
        buf.writeByte(this.outputLevel);
        buf.writeByte(this.inputLevel);
        buf.writeByte(this.channel);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PneumaticCraftUtils.getTileEntityAt((BlockGetter)ClientUtils.getClientLevel(), this.pos, PressureTubeBlockEntity.class).ifPresent(te -> {
            AbstractTubeModule patt2851$temp = te.getModule(this.side);
            if (patt2851$temp instanceof RedstoneModule) {
                RedstoneModule mr = (RedstoneModule)patt2851$temp;
                mr.setColorChannel(this.channel);
                mr.setRedstoneDirection(this.dir);
                mr.setOutputLevel(this.outputLevel);
                mr.setInputLevel(this.inputLevel);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

