/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncAmadronOffers {
    private final Collection<AmadronRecipe> activeOffers;
    private final boolean notifyPlayer;

    public PacketSyncAmadronOffers(boolean notifyPlayer) {
        this.notifyPlayer = notifyPlayer;
        this.activeOffers = AmadronOfferManager.getInstance().getActiveOffers();
    }

    public PacketSyncAmadronOffers(FriendlyByteBuf buf) {
        this.notifyPlayer = buf.readBoolean();
        this.activeOffers = new ArrayList<AmadronRecipe>();
        int offerCount = buf.m_130242_();
        for (int i = 0; i < offerCount; ++i) {
            if (buf.readBoolean()) {
                this.activeOffers.add(AmadronPlayerOffer.playerOfferFromBuf(buf.m_130281_(), buf));
                continue;
            }
            this.activeOffers.add(AmadronOffer.offerFromBuf(buf.m_130281_(), buf));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.notifyPlayer);
        buf.m_130130_(this.activeOffers.size());
        for (AmadronRecipe offer : this.activeOffers) {
            buf.writeBoolean(offer instanceof AmadronPlayerOffer);
            buf.m_130085_(offer.m_6423_());
            offer.write(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> AmadronOfferManager.getInstance().syncOffers(this.activeOffers, this.notifyPlayer));
        ctx.get().setPacketHandled(true);
    }
}

