/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketMultiHeader {
    private final int length;
    private final String className;
    private static final Map<UUID, PayloadBuffer> payloadBuffers = new HashMap<UUID, PayloadBuffer>();

    PacketMultiHeader(int length, String className) {
        this.length = length;
        this.className = className;
    }

    PacketMultiHeader(FriendlyByteBuf buffer) {
        this.length = buffer.readInt();
        this.className = buffer.m_130136_(Short.MAX_VALUE);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.length);
        buf.m_130070_(this.className);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = PacketMultiHeader.class.getClassLoader();
                }
                Class<?> clazz = cl.loadClass(this.className);
                UUID id = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtils.getClientPlayer().m_20148_() : ((NetworkEvent.Context)ctx.get()).getSender().m_20148_();
                payloadBuffers.put(id, new PayloadBuffer(clazz.asSubclass(ILargePayload.class), this.length));
            }
            catch (ClassCastException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static void receivePayload(Player player, byte[] payload) {
        UUID id = player == null ? ClientUtils.getClientPlayer().m_20148_() : player.m_20148_();
        PayloadBuffer buffer = payloadBuffers.get(id);
        if (buffer != null) {
            System.arraycopy(payload, 0, buffer.payload, buffer.offset, payload.length);
            buffer.offset += 32000;
            if (buffer.offset > buffer.payload.length) {
                try {
                    Constructor<? extends ILargePayload> ctor = buffer.clazz.getConstructor(FriendlyByteBuf.class);
                    ILargePayload packet = ctor.newInstance(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.payload)));
                    packet.handleLargePayload(player);
                    payloadBuffers.remove(id);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Log.error("Received unexpected multi-message payload from player " + String.valueOf(player.m_7755_()) + " - " + String.valueOf(player.m_20148_()), new Object[0]);
        }
    }

    private static class PayloadBuffer {
        final Class<? extends ILargePayload> clazz;
        final byte[] payload;
        int offset;

        PayloadBuffer(Class<? extends ILargePayload> clazz, int length) {
            this.clazz = clazz;
            this.payload = new byte[length];
        }
    }
}

