/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class FreezingGunAmmoItem
extends AbstractGunAmmoItem {
    @Override
    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.freezingAmmoCartridgeSize.get();
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 4235519;
    }

    @Override
    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        double mul = super.getDamageMultiplier(target, ammoStack);
        if (target != null && target.m_5825_()) {
            mul *= 1.5;
        }
        return (float)mul;
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_146924_(true);
            living.m_146917_(living.m_146888_() + 35);
            if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.freezingAmmoEntityIceChance.get())) {
                this.createFreezeCloud(minigun, target);
            }
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    private void createFreezeCloud(Minigun minigun, Entity target) {
        Level world = target.m_20193_();
        AreaEffectCloud cloud = new AreaEffectCloud(world, target.m_20185_(), target.m_20186_(), target.m_20189_());
        cloud.m_19722_(Potions.f_43615_);
        cloud.m_19718_((LivingEntity)minigun.getPlayer());
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19597_, 100, 3));
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19615_, 20, 1));
        cloud.m_19712_(2.0f);
        cloud.m_19734_(60);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(20);
        cloud.m_19714_(-16727809);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        world.m_7967_((Entity)cloud);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        Level world = minigun.getWorld();
        BlockPos pos = brtr.m_82425_();
        if (!world.m_6042_().f_63857_() && minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.freezingAmmoBlockIceChance.get())) {
            Vec3 eye;
            ClipContext ctx;
            BlockHitResult res;
            BlockPos pos1 = world.m_8055_(pos).m_60808_((BlockGetter)world, pos) == Shapes.m_83144_() || brtr.m_82434_() != Direction.UP ? pos.m_121945_(brtr.m_82434_()) : pos;
            BlockState newState = null;
            if (world.m_46859_(pos1) && !world.m_46859_(pos1.m_7495_())) {
                newState = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(1));
            } else if (world.m_8055_(pos1).m_60734_() == Blocks.f_50125_) {
                BlockState state = world.m_8055_(pos1);
                int level = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                newState = level < 8 ? (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(level + 1)) : Blocks.f_50127_.m_49966_();
            } else if (world.m_8055_(pos1).m_60734_() == Blocks.f_49990_ && (res = world.m_45547_(ctx = new ClipContext(eye = minigun.getPlayer().m_20299_(0.0f), brtr.m_82450_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)minigun.getPlayer()))).m_6662_() == HitResult.Type.BLOCK) {
                pos1 = res.m_82425_();
                newState = Blocks.f_50126_.m_49966_();
            }
            if (newState != null) {
                PneumaticCraftUtils.tryPlaceBlock(world, pos1, minigun.getPlayer(), brtr.m_82434_(), newState);
            }
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }
}

