/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory.slot;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class PlayerEquipmentSlot
extends Slot {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private final EquipmentSlot slotType;

    public PlayerEquipmentSlot(Inventory inventoryIn, EquipmentSlot slotType, int xPosition, int yPosition) {
        super((Container)inventoryIn, PlayerEquipmentSlot.getIndexForSlot(slotType), xPosition, yPosition);
        this.slotType = slotType;
    }

    public int m_6641_() {
        return this.slotType == EquipmentSlot.OFFHAND ? super.m_6641_() : 1;
    }

    public boolean m_5857_(ItemStack stack) {
        return this.slotType == EquipmentSlot.OFFHAND ? super.m_5857_(stack) : stack.canEquip(this.slotType, (Entity)((Inventory)this.f_40218_).f_35978_);
    }

    public boolean m_8010_(Player playerIn) {
        if (this.slotType == EquipmentSlot.OFFHAND) {
            return super.m_8010_(playerIn);
        }
        ItemStack itemstack = this.m_7993_();
        return (itemstack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(playerIn);
    }

    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return this.slotType.m_20743_() == EquipmentSlot.Type.ARMOR ? Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[this.slotType.m_20749_()]) : Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
    }

    private static int getIndexForSlot(EquipmentSlot type) {
        if (type.m_20743_() == EquipmentSlot.Type.ARMOR) {
            return 36 + type.m_20749_();
        }
        if (type == EquipmentSlot.OFFHAND) {
            return 40;
        }
        throw new IllegalArgumentException("invalid equipment slot: " + String.valueOf(type));
    }
}

