/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class JackhammerSetupMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    private final JackHammerItem.DrillBitHandler drillBitHandler;
    private final JackHammerItem.EnchantmentHandler enchantmentHandler;
    private final InteractionHand hand;

    public JackhammerSetupMenu(int windowId, Inventory invPlayer, FriendlyByteBuf buffer) {
        this(windowId, invPlayer, JackhammerSetupMenu.getHand(buffer));
    }

    public JackhammerSetupMenu(int windowId, Inventory invPlayer, InteractionHand hand) {
        super((MenuType)ModMenuTypes.JACKHAMMER_SETUP.get(), windowId, invPlayer);
        this.hand = hand;
        this.drillBitHandler = JackHammerItem.getDrillBitHandler(invPlayer.f_35978_.m_21120_(hand));
        if (this.drillBitHandler != null) {
            this.m_38897_((Slot)new SlotDrillBit(this.drillBitHandler, 0, 128, 19));
        }
        this.enchantmentHandler = JackHammerItem.getEnchantmentHandler(invPlayer.f_35978_.m_21120_(hand));
        if (this.enchantmentHandler != null) {
            this.m_38897_((Slot)new SlotEnchantmentHandler(this.enchantmentHandler, 0, 96, 19));
        }
        this.addPlayerSlots(invPlayer, 100);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.drillBitHandler.save();
        this.enchantmentHandler.save();
    }

    @Override
    public boolean m_6875_(Player player) {
        return player.m_21120_(this.hand).m_41720_() == ModItems.JACKHAMMER.get();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        ItemStack hammerStack = player.m_21120_(this.hand);
        if (tag.startsWith("digmode:") && hammerStack.m_41720_() instanceof JackHammerItem) {
            try {
                DrillBitItem.DrillBitType ourBit = ((JackHammerItem)hammerStack.m_41720_()).getDrillBit(hammerStack);
                JackHammerItem.DigMode newDigMode = JackHammerItem.DigMode.valueOf(tag.substring(8));
                if (ourBit.getBitQuality() >= newDigMode.getBitType().getBitQuality() || newDigMode == JackHammerItem.DigMode.MODE_1X1) {
                    JackHammerItem.setDigMode(hammerStack, newDigMode);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    private static class SlotDrillBit
    extends SlotItemHandler {
        public SlotDrillBit(JackHammerItem.DrillBitHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return stack.m_41720_() instanceof DrillBitItem;
        }

        public void m_6654_() {
            ((JackHammerItem.DrillBitHandler)this.getItemHandler()).save();
        }

        public void m_40234_(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            ((JackHammerItem.DrillBitHandler)this.getItemHandler()).save();
        }
    }

    private static class SlotEnchantmentHandler
    extends SlotItemHandler {
        public SlotEnchantmentHandler(JackHammerItem.EnchantmentHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return JackHammerItem.EnchantmentHandler.validateBook(stack);
        }

        public void m_40234_(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            ((JackHammerItem.EnchantmentHandler)this.getItemHandler()).save();
        }

        public void m_6654_() {
            ((JackHammerItem.EnchantmentHandler)this.getItemHandler()).save();
        }
    }
}

