/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.entity.semiblock.HeatFrameEntity;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicTicking;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class HeatBehaviourHeatFrame
extends HeatBehaviour {
    static final ResourceLocation ID = PneumaticRegistry.RL("heat_frame");
    private HeatFrameEntity semiBlock;

    @Override
    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, Level world, BlockPos pos, Direction direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.semiBlock = null;
        return this;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    private HeatFrameEntity getHeatFrame() {
        ISemiBlock s;
        if ((this.semiBlock == null || !this.semiBlock.m_6084_()) && (s = SemiblockTracker.getInstance().getSemiblock(this.getWorld(), this.getPos())) instanceof HeatFrameEntity) {
            this.semiBlock = (HeatFrameEntity)s;
        }
        return this.semiBlock;
    }

    @Override
    public boolean isApplicable() {
        return this.getHeatFrame() != null;
    }

    @Override
    public void tick() {
        HeatExchangerLogicTicking.exchange(this.getHeatFrame().getHeatExchangerLogic(), this.getHeatExchanger());
    }
}

