/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIHarvest;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetHarvest
extends ProgWidgetDigAndPlace
implements IToolUser {
    private boolean requireHoe;

    public ProgWidgetHarvest() {
        super((ProgWidgetType)ModProgWidgets.HARVEST.get(), IBlockOrdered.Ordering.CLOSEST);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_HARVEST;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIHarvest<ProgWidgetAreaItemBase>(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.BROWN;
    }

    @Override
    public boolean requiresTool() {
        return this.requireHoe;
    }

    @Override
    public void setRequiresTool(boolean requireHoe) {
        this.requireHoe = requireHoe;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.requiresTool()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.harvest.requiresHoe", new Object[0]));
        }
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.requireHoe) {
            tag.m_128379_("requireHoe", true);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.requireHoe = tag.m_128471_("requireHoe");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.requireHoe);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.requireHoe = buf.readBoolean();
    }
}

