/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class ProgWidgetDroneCondition
extends ProgWidgetConditionBase
implements ICondition,
IVariableSetWidget {
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.GE;
    private int requiredCount = 1;
    private String measureVar = "";

    public ProgWidgetDroneCondition(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        return this.getOperator().evaluate(this.getCount(drone, widget), this.getRequiredCount());
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.measureVar.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]).m_130946_(this.measureVar));
        }
    }

    protected abstract int getCount(IDroneBase var1, IProgWidget var2);

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        if (widget instanceof ProgWidgetDroneCondition) {
            return null;
        }
        return new Goal(){

            public boolean m_8036_() {
                return false;
            }
        };
    }

    @Override
    public int getRequiredCount() {
        return this.requiredCount;
    }

    @Override
    public void setRequiredCount(int count) {
        this.requiredCount = count;
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public String getMeasureVar() {
        return this.measureVar;
    }

    @Override
    public void setMeasureVar(String measureVar) {
        this.measureVar = measureVar;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.isAndFunction) {
            tag.m_128379_("isAndFunction", true);
        }
        tag.m_128344_("operator", (byte)this.operator.ordinal());
        tag.m_128405_("requiredCount", this.requiredCount);
        if (!this.measureVar.isEmpty()) {
            tag.m_128359_("measureVar", this.measureVar);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.m_128471_("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.m_128445_("operator")];
        this.requiredCount = tag.m_128451_("requiredCount");
        this.measureVar = tag.m_128461_("measureVar");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.isAndFunction);
        buf.writeByte(this.operator.ordinal());
        buf.m_130130_(this.requiredCount);
        buf.m_130072_(this.measureVar, 64);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.isAndFunction = buf.readBoolean();
        this.operator = ICondition.Operator.values()[buf.readByte()];
        this.requiredCount = buf.m_130242_();
        this.measureVar = buf.m_130136_(64);
    }

    @Override
    public List<Component> getExtraStringInfo() {
        MutableComponent anyAll = PneumaticCraftUtils.xlate(this.isAndFunction() ? "pneumaticcraft.gui.misc.all" : "pneumaticcraft.gui.misc.any", new Object[0]).m_130946_(" " + this.getOperator().toString() + " " + this.getRequiredCount());
        return this.measureVar.isEmpty() ? Collections.singletonList(anyAll) : ImmutableList.of((Object)anyAll, (Object)this.varAsTextComponent(this.measureVar));
    }

    @Override
    public void addVariables(Set<String> variables) {
        if (!this.getMeasureVar().isEmpty()) {
            variables.add(this.getMeasureVar());
        }
    }

    @Override
    public String getVariable() {
        return this.getMeasureVar();
    }

    @Override
    public void setVariable(String variable) {
        this.setMeasureVar(variable);
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
    }
}

