/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.DroneClaimManager;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class DroneGoToChargingStation
extends Goal {
    private final DroneEntity drone;
    public boolean isExecuting;
    private ChargingStationBlockEntity curCharger;
    private int chargingTime;

    public DroneGoToChargingStation(DroneEntity drone) {
        this.drone = drone;
        this.m_7021_(EnumSet.allOf(Goal.Flag.class));
    }

    public boolean m_8036_() {
        ArrayList<ChargingStationBlockEntity> validChargingStations = new ArrayList<ChargingStationBlockEntity>();
        this.drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> {
            if (h.getPressure() < 1.0f && h.getPressure() > 0.001f) {
                int maxDistSq = (Integer)ConfigHelper.common().drones.maxDroneChargingStationSearchRange.get() * (Integer)ConfigHelper.common().drones.maxDroneChargingStationSearchRange.get();
                for (ChargingStationBlockEntity station : GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.drone.m_9236_()).getChargingStations()) {
                    Level level = this.drone.m_9236_();
                    BlockPos chargingPos = station.m_58899_();
                    if (station.m_58904_() != level || !level.m_46749_(chargingPos) || !(this.drone.m_20238_(Vec3.m_82512_((Vec3i)chargingPos)) <= (double)maxDistSq)) continue;
                    if (DroneClaimManager.getInstance(this.drone.m_9236_()).isClaimed(chargingPos)) {
                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.claimed", chargingPos);
                        continue;
                    }
                    if (station.getPressure() <= 1.0f) {
                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.notEnoughPressure", chargingPos);
                        continue;
                    }
                    if (station.getUpgrades(ModUpgrades.DISPENSER.get()) == 0) {
                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.noDispenserUpgrades", chargingPos);
                        continue;
                    }
                    validChargingStations.add(station);
                }
            }
        });
        validChargingStations.sort(Comparator.comparingDouble(te -> te.m_58899_().m_123331_((Vec3i)this.drone.m_20183_())));
        for (ChargingStationBlockEntity station : validChargingStations) {
            if (SecurityStationBlockEntity.isProtectedFromPlayer((Player)this.drone.getFakePlayer(), station.m_58899_(), false)) {
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.protected", station.m_58899_());
                continue;
            }
            if (this.drone.getPathNavigator().moveToXYZ((double)station.m_58899_().m_123341_() + 0.5, station.m_58899_().m_123342_() + 1, (double)station.m_58899_().m_123343_() + 0.5) || this.drone.getPathNavigator().isGoingToTeleport()) {
                this.isExecuting = true;
                this.curCharger = station;
                DroneClaimManager.getInstance(this.drone.m_9236_()).claim(station.m_58899_());
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.cantNavigate", station.m_58899_());
        }
        this.isExecuting = false;
        return false;
    }

    public boolean m_8045_() {
        if (this.curCharger.getUpgrades(ModUpgrades.DISPENSER.get()) == 0 || this.curCharger.m_58901_()) {
            this.isExecuting = false;
            return false;
        }
        if (!this.drone.getPathNavigator().isGoingToTeleport() && (this.drone.m_21573_().m_26570_() == null || this.drone.m_21573_().m_26570_().m_77392_())) {
            this.isExecuting = (Boolean)this.drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).map(h -> h.getPressure() < 9.9f && this.curCharger.getPressure() > h.getPressure() + 0.1f).orElseThrow(RuntimeException::new);
            if (this.isExecuting) {
                ++this.chargingTime;
                if (this.chargingTime > 20) {
                    this.drone.getPathNavigator().moveToXYZ((double)this.curCharger.m_58899_().m_123341_() + 0.5, (double)this.curCharger.m_58899_().m_123342_() + 1.5, (double)this.curCharger.m_58899_().m_123343_() + 0.5);
                    if (this.drone.m_21573_().m_26570_() == null || this.drone.m_21573_().m_26570_().m_77392_()) {
                        this.drone.setStandby(true, false);
                    } else {
                        this.chargingTime = 0;
                    }
                }
                DroneClaimManager.getInstance(this.drone.m_9236_()).claim(this.curCharger.m_58899_());
            }
            return this.isExecuting;
        }
        this.chargingTime = 0;
        DroneClaimManager.getInstance(this.drone.m_9236_()).claim(this.curCharger.m_58899_());
        return this.drone.isAccelerating();
    }
}

