/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DistanceEntitySorter;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class DroneEntityBase<W extends IEntityProvider, E extends Entity>
extends Goal {
    protected final IDroneBase drone;
    protected final W progWidget;
    protected E targetedEntity;

    protected DroneEntityBase(IDroneBase drone, W progWidget) {
        this.drone = drone;
        this.m_7021_(EnumSet.allOf(Goal.Flag.class));
        this.progWidget = progWidget;
    }

    public boolean m_8036_() {
        List<Entity> pickableItems = this.progWidget.getValidEntities(this.drone.world());
        pickableItems.sort(new DistanceEntitySorter(this.drone));
        for (Entity ent : pickableItems) {
            if (ent == this.drone || !this.isEntityValid(ent)) continue;
            if (this.drone.getPathNavigator().moveToEntity(ent)) {
                this.targetedEntity = ent;
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate");
        }
        return false;
    }

    protected abstract boolean isEntityValid(Entity var1);

    public boolean m_8045_() {
        if (!this.targetedEntity.m_6084_()) {
            return false;
        }
        if (this.targetedEntity.m_20182_().m_82557_(this.drone.getDronePos()) < 2.25) {
            return this.doAction();
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    protected abstract boolean doAction();
}

