/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.common.block.ElevatorCallerBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;

public class ElevatorCallerBlockEntity
extends AbstractTickingBlockEntity
implements CamouflageableBlockEntity,
IRedstoneControl<ElevatorCallerBlockEntity> {
    private ElevatorButton[] floors = new ElevatorButton[0];
    private int thisFloor;
    private boolean emittingRedstone;
    private boolean shouldUpdateNeighbors;
    private BlockState camoState;
    private final RedstoneController<ElevatorCallerBlockEntity> rsController = new RedstoneController<ElevatorCallerBlockEntity>(this);

    public ElevatorCallerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.ELEVATOR_CALLER.get()), pos, state);
    }

    public void setEmittingRedstone(boolean emittingRedstone) {
        if (emittingRedstone != this.emittingRedstone) {
            this.emittingRedstone = emittingRedstone;
            this.shouldUpdateNeighbors = true;
        }
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (this.shouldUpdateNeighbors) {
            this.updateNeighbours();
            this.shouldUpdateNeighbors = false;
        }
    }

    public boolean getEmittingRedstone() {
        return this.emittingRedstone;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.emittingRedstone = tag.m_128471_("emittingRedstone");
        this.thisFloor = tag.m_128451_("thisFloor");
        this.shouldUpdateNeighbors = tag.m_128471_("shouldUpdateNeighbors");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("emittingRedstone", this.emittingRedstone);
        tag.m_128405_("thisFloor", this.thisFloor);
        tag.m_128379_("shouldUpdateNeighbors", this.shouldUpdateNeighbors);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        int floorAmount = tag.m_128451_("floors");
        this.floors = new ElevatorButton[floorAmount];
        for (int i = 0; i < floorAmount; ++i) {
            this.floors[i] = new ElevatorButton(tag.m_128469_("floor" + i));
        }
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.m_128405_("floors", this.floors.length);
        for (ElevatorButton floor : this.floors) {
            tag.m_128365_("floor" + floor.floorNumber, (Tag)floor.writeToNBT(new CompoundTag()));
        }
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        boolean wasPowered = this.getRedstoneController().getCurrentRedstonePower() > 0;
        super.onNeighborBlockUpdate(fromPos);
        if (this.getRedstoneController().getCurrentRedstonePower() > 0 && !wasPowered) {
            ElevatorCallerBlock.setSurroundingElevators(this.m_58904_(), this.m_58899_(), this.thisFloor);
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    void setFloors(ElevatorButton[] floors, int thisFloorLevel) {
        this.floors = floors;
        this.thisFloor = thisFloorLevel;
        this.sendDescriptionPacket();
    }

    public ElevatorButton[] getFloors() {
        return this.floors;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    @Override
    public RedstoneController<ElevatorCallerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    public static class ElevatorButton {
        public final float posX;
        public final float posY;
        public final float width;
        public final float height;
        public final int floorNumber;
        public final int floorHeight;
        public float red;
        public float green;
        public float blue;
        public String buttonText;

        ElevatorButton(float posX, float posY, float width, float height, int floorNumber, int floorHeight) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.floorNumber = floorNumber;
            this.floorHeight = floorHeight;
            this.buttonText = "" + (floorNumber + 1);
        }

        ElevatorButton(CompoundTag tag) {
            this.posX = tag.m_128457_("posX");
            this.posY = tag.m_128457_("posY");
            this.width = tag.m_128457_("width");
            this.height = tag.m_128457_("height");
            this.buttonText = tag.m_128461_("buttonText");
            this.floorNumber = tag.m_128451_("floorNumber");
            this.floorHeight = tag.m_128451_("floorHeight");
            this.red = tag.m_128457_("red");
            this.green = tag.m_128457_("green");
            this.blue = tag.m_128457_("blue");
        }

        void setColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public CompoundTag writeToNBT(CompoundTag tag) {
            tag.m_128350_("posX", this.posX);
            tag.m_128350_("posY", this.posY);
            tag.m_128350_("width", this.width);
            tag.m_128350_("height", this.height);
            tag.m_128359_("buttonText", this.buttonText);
            tag.m_128405_("floorNumber", this.floorNumber);
            tag.m_128405_("floorHeight", this.floorHeight);
            tag.m_128350_("red", this.red);
            tag.m_128350_("green", this.green);
            tag.m_128350_("blue", this.blue);
            return tag;
        }
    }
}

