/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractHopperBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.OmnidirectionalHopperBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OmnidirectionalHopperBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_SHAPE = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.m_83110_((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape BOWL_SHAPE = Block.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape INPUT_UP = Shapes.m_83113_((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)BOWL_SHAPE, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape INPUT_NORTH = VoxelShapeUtils.rotateX(INPUT_UP, 270);
    private static final VoxelShape INPUT_DOWN = VoxelShapeUtils.rotateX(INPUT_NORTH, 270);
    private static final VoxelShape INPUT_SOUTH = VoxelShapeUtils.rotateX(INPUT_UP, 90);
    private static final VoxelShape INPUT_WEST = VoxelShapeUtils.rotateY(INPUT_NORTH, 270);
    private static final VoxelShape INPUT_EAST = VoxelShapeUtils.rotateY(INPUT_NORTH, 90);
    public static final VoxelShape[] INPUT_SHAPES = new VoxelShape[]{INPUT_DOWN, INPUT_UP, INPUT_NORTH, INPUT_SOUTH, INPUT_WEST, INPUT_EAST};
    private static final VoxelShape OUTPUT_DOWN = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), (VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape OUTPUT_UP = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), (VoxelShape)Block.m_49796_((double)6.5, (double)12.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape OUTPUT_NORTH = VoxelShapeUtils.rotateX(OUTPUT_DOWN, 90);
    private static final VoxelShape OUTPUT_SOUTH = VoxelShapeUtils.rotateX(OUTPUT_DOWN, 270);
    private static final VoxelShape OUTPUT_WEST = VoxelShapeUtils.rotateY(OUTPUT_NORTH, 270);
    private static final VoxelShape OUTPUT_EAST = VoxelShapeUtils.rotateY(OUTPUT_NORTH, 90);
    private static final VoxelShape[] OUTPUT_SHAPES = new VoxelShape[]{OUTPUT_DOWN, OUTPUT_UP, OUTPUT_NORTH, OUTPUT_SOUTH, OUTPUT_WEST, OUTPUT_EAST};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[36];
    public static final EnumProperty<Direction> INPUT_FACING = EnumProperty.m_61587_((String)"input", Direction.class);

    public OmnidirectionalHopperBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int idx = ((Direction)state.m_61143_(INPUT_FACING)).m_122411_() + ((Direction)state.m_61143_((Property)this.directionProperty())).m_122411_() * 6;
        if (SHAPE_CACHE[idx] == null) {
            OmnidirectionalHopperBlock.SHAPE_CACHE[idx] = Shapes.m_83113_((VoxelShape)INPUT_SHAPES[((Direction)state.m_61143_(INPUT_FACING)).m_122411_()], (VoxelShape)OUTPUT_SHAPES[((Direction)state.m_61143_((Property)this.directionProperty())).m_122411_()], (BooleanOp)BooleanOp.f_82695_);
        }
        return SHAPE_CACHE[idx];
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{INPUT_FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return state;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)ctx.m_43719_().m_122424_())).m_61124_(INPUT_FACING, (Comparable)ctx.m_7820_().m_122424_());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    private Direction getInputDirection(Level world, BlockPos pos) {
        return (Direction)world.m_8055_(pos).m_61143_(INPUT_FACING);
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        BlockState state = world.m_8055_(pos);
        if (player != null && player.m_6144_()) {
            Direction outputDir = this.getRotation(state);
            if ((outputDir = Direction.m_122376_((int)(outputDir.m_122411_() + 1))) == this.getInputDirection(world, pos)) {
                outputDir = Direction.m_122376_((int)(outputDir.m_122411_() + 1));
            }
            this.setRotation(world, pos, outputDir);
        } else {
            Direction inputDir = (Direction)state.m_61143_(INPUT_FACING);
            if ((inputDir = Direction.m_122376_((int)(inputDir.m_122411_() + 1))) == this.getRotation((BlockGetter)world, pos)) {
                inputDir = Direction.m_122376_((int)(inputDir.m_122411_() + 1));
            }
            world.m_46597_(pos, (BlockState)state.m_61124_(INPUT_FACING, (Comparable)inputDir));
        }
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractHopperBlockEntity.class).ifPresent(AbstractHopperBlockEntity::onBlockRotated);
        return true;
    }

    @Override
    public int getTintColor(BlockState state, @javax.annotation.Nullable BlockAndTintGetter world, @javax.annotation.Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            switch (tintIndex) {
                case 0: {
                    return PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractHopperBlockEntity.class).filter(te -> te.isCreative).map(te -> -2406705).orElse(-13949145);
                }
                case 1: {
                    return -6250336;
                }
            }
        }
        return -1;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new OmnidirectionalHopperBlockEntity(pPos, pState);
    }

    public static class ItemBlockOmnidirectionalHopper
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockOmnidirectionalHopper(Block block) {
            super(block, ModItems.defaultProps());
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            int n = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get());
            return n > 0 ? -2406705 : -13949145;
        }
    }
}

