/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer3D;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.PressureGaugeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class PressureGaugeRenderer
extends AbstractTubeModuleRenderer<PressureGaugeModule> {
    private static final float GAUGE_SCALE = 0.007f;
    private static final Component BAR = Component.m_237113_((String)"bar");
    private final Font font;
    private final ModelPart tubeConnector1;
    private final ModelPart tubeConnector2;
    private final ModelPart faceplate;
    private final ModelPart gauge1;
    private final ModelPart gauge2;
    private final ModelPart gauge3;
    private final ModelPart gauge4;
    private final ModelPart gauge5;
    private final ModelPart gauge6;
    private final ModelPart gauge7;
    private final ModelPart gauge8;
    private static final String TUBECONNECTOR1 = "tubeConnector1";
    private static final String TUBECONNECTOR2 = "tubeConnector2";
    private static final String FACEPLATE = "faceplate";
    private static final String GAUGE1 = "gauge1";
    private static final String GAUGE2 = "gauge2";
    private static final String GAUGE3 = "gauge3";
    private static final String GAUGE4 = "gauge4";
    private static final String GAUGE5 = "gauge5";
    private static final String GAUGE6 = "gauge6";
    private static final String GAUGE7 = "gauge7";
    private static final String GAUGE8 = "gauge8";

    public PressureGaugeRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.m_173586_();
        ModelPart root = ctx.m_173582_(PNCModelLayers.PRESSURE_GAUGE_MODULE);
        this.tubeConnector1 = root.m_171324_(TUBECONNECTOR1);
        this.tubeConnector2 = root.m_171324_(TUBECONNECTOR2);
        this.faceplate = root.m_171324_(FACEPLATE);
        this.gauge1 = root.m_171324_(GAUGE1);
        this.gauge2 = root.m_171324_(GAUGE2);
        this.gauge3 = root.m_171324_(GAUGE3);
        this.gauge4 = root.m_171324_(GAUGE4);
        this.gauge5 = root.m_171324_(GAUGE5);
        this.gauge6 = root.m_171324_(GAUGE6);
        this.gauge7 = root.m_171324_(GAUGE7);
        this.gauge8 = root.m_171324_(GAUGE8);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(TUBECONNECTOR1, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171517_("tubeConnector1_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.m_171599_(TUBECONNECTOR2, CubeListBuilder.m_171558_().m_171514_(22, 6).m_171517_("tubeConnector2_0", -2.0f, -2.0f, 2.0f, 7.0f, 7.0f, 1.0f), PartPose.m_171419_((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.m_171599_(FACEPLATE, CubeListBuilder.m_171558_().m_171514_(0, 6).m_171517_("faceplate_0", -1.0f, -1.0f, 0.0f, 10.0f, 10.0f, 1.0f), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)5.0f));
        partdefinition.m_171599_(GAUGE1, CubeListBuilder.m_171558_().m_171514_(0, 17).m_171517_("gauge1_0", -3.0f, -2.0f, 0.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE2, CubeListBuilder.m_171558_().m_171514_(4, 17).m_171517_("gauge2_0", 4.0f, -2.0f, 0.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE3, CubeListBuilder.m_171558_().m_171514_(8, 17).m_171517_("gauge3_0", 3.0f, -3.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE4, CubeListBuilder.m_171558_().m_171514_(12, 17).m_171517_("gauge4_0", 3.0f, 2.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE5, CubeListBuilder.m_171558_().m_171514_(8, 19).m_171517_("gauge5_0", -2.0f, -3.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE6, CubeListBuilder.m_171558_().m_171514_(12, 19).m_171517_("gauge6_0", -2.0f, 2.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE7, CubeListBuilder.m_171558_().m_171514_(0, 24).m_171517_("gauge7_0", -1.0f, 3.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.m_171599_(GAUGE8, CubeListBuilder.m_171558_().m_171514_(0, 22).m_171517_("gauge8_0", -1.0f, -4.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)16.0f, (float)5.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    protected void render(PressureGaugeModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, float alpha) {
        this.tubeConnector1.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector2.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.faceplate.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge1.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge2.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge3.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge4.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge5.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge6.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge7.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge8.m_104306_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
    }

    @Override
    public void renderExtras(PressureGaugeModule module, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, int combinedLight, int combinedOverlay) {
        if (module.isFake()) {
            return;
        }
        BlockPos pos = module.getTube().m_58899_();
        if (ClientUtils.getClientPlayer().m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 256.0) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        RenderUtils.rotateMatrixForDirection(matrixStack, module.getDirection());
        PressureTubeBlockEntity te = module.getTube();
        matrixStack.m_85837_(0.0, 1.01, 0.378);
        matrixStack.m_85841_(0.007f, 0.007f, 0.007f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (module.shouldShowGauge()) {
            PressureGaugeRenderer3D.drawPressureGauge(matrixStack, buffer, -1.0f, te.getCriticalPressure(), te.getDangerPressure(), 0.0f, te.getPressure(), 0, 0, -16777216);
        } else {
            MutableComponent s = Component.m_237113_((String)PneumaticCraftUtils.roundNumberTo(te.getPressure(), 1));
            RenderUtils.renderString3d((Component)s, (float)(-this.font.m_92852_((FormattedText)s)) / 2.0f, -10.0f, 0, matrixStack, buffer, false, false);
            RenderUtils.renderString3d(BAR, (float)(-this.font.m_92852_((FormattedText)BAR)) / 2.0f, 0.0f, 0, matrixStack, buffer, false, false);
        }
        matrixStack.m_85849_();
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_GAUGE_UPGRADED : Textures.MODEL_GAUGE;
    }
}

