/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTER;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.entity.LiquidHopperBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RenderLiquidHopper
extends AbstractFluidTER<LiquidHopperBlockEntity> {
    private static final AABB[] BOUNDS = new AABB[6];

    public RenderLiquidHopper(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    Collection<TankRenderInfo> getTanksToRender(LiquidHopperBlockEntity te) {
        return ImmutableList.of((Object)new TankRenderInfo(te.getTank(), BOUNDS[te.getInputDirection().m_122411_()], new Direction[0]));
    }

    static {
        RenderLiquidHopper.BOUNDS[Direction.DOWN.m_122411_()] = new AABB(0.031875, 0.031875, 0.031875, 0.968125, 0.311875, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.UP.m_122411_()] = new AABB(0.031875, 0.688125, 0.031875, 0.968125, 0.968125, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.NORTH.m_122411_()] = new AABB(0.031875, 0.031875, 0.031875, 0.968125, 0.968125, 0.311875);
        RenderLiquidHopper.BOUNDS[Direction.SOUTH.m_122411_()] = new AABB(0.031875, 0.031875, 0.718125, 0.968125, 0.968125, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.WEST.m_122411_()] = new AABB(0.031875, 0.031875, 0.031875, 0.311875, 0.968125, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.EAST.m_122411_()] = new AABB(0.688125, 0.031875, 0.031875, 0.968125, 0.968125, 0.968125);
    }

    public static class ItemRenderInfoProvider
    implements IFluidItemRenderInfoProvider {
        private static final AABB BOUNDS_UP = BOUNDS[Direction.UP.m_122411_()];

        @Override
        public List<TankRenderInfo> getTanksToRender(ItemStack stack) {
            IFluidHandler h = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(RuntimeException::new);
            return Collections.singletonList(new TankRenderInfo(h.getFluidInTank(0), h.getTankCapacity(0), BOUNDS_UP, new Direction[0]).without(Direction.DOWN));
        }
    }
}

