/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

abstract class RenderSemiblockBase<T extends AbstractSemiblockEntity>
extends EntityRenderer<T> {
    private static final Direction[] LIGHTING_DIRS = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN};

    RenderSemiblockBase(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    void wobble(T entityIn, float partialTicks, PoseStack matrixStack) {
        float f = (float)((AbstractSemiblockEntity)entityIn).getTimeSinceHit() - partialTicks;
        float f1 = ((AbstractSemiblockEntity)entityIn).getDamageTaken() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            Vec3 look = Minecraft.m_91087_().f_91074_.m_20252_(partialTicks);
            Vector3f wobble = new Vector3f((float)look.m_7094_(), 0.0f, -((float)look.m_7096_()));
            matrixStack.m_252781_(Axis.m_253057_((Vector3f)wobble).m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * 1.0f));
        }
    }

    int kludgeLightingLevel(T entityIn, int packedLight) {
        if (packedLight == 0) {
            BlockPos pos = ((AbstractSemiblockEntity)entityIn).getBlockPos();
            for (Direction d : LIGHTING_DIRS) {
                BlockPos pos2 = pos.m_121945_(d);
                if (Block.m_49863_((LevelReader)entityIn.m_9236_(), (BlockPos)pos2, (Direction)d.m_122424_())) continue;
                int block = entityIn.m_9236_().m_45517_(LightLayer.BLOCK, pos2);
                int sky = entityIn.m_9236_().m_45517_(LightLayer.SKY, pos2);
                return LightTexture.m_109885_((int)block, (int)sky);
            }
        }
        return packedLight;
    }
}

