/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberInterfaceBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;

public class PressureChamberInterfaceRenderer
extends AbstractBlockEntityModelRenderer<PressureChamberInterfaceBlockEntity> {
    private final ModelPart inputLeft;
    private final ModelPart inputRight;
    private final ModelPart inputBottom;
    private final ModelPart inputTop;
    private final ModelPart outputLeft;
    private final ModelPart outputRight;
    private final ModelPart outputBottom;
    private final ModelPart outputTop;
    private static final String INPUTLEFT = "inputLeft";
    private static final String INPUTRIGHT = "inputRight";
    private static final String INPUTBOTTOM = "inputBottom";
    private static final String INPUTTOP = "inputTop";
    private static final String OUTPUTLEFT = "outputLeft";
    private static final String OUTPUTRIGHT = "outputRight";
    private static final String OUTPUTBOTTOM = "outputBottom";
    private static final String OUTPUTTOP = "outputTop";

    public PressureChamberInterfaceRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.PRESSURE_CHAMBER_INTERFACE);
        this.inputLeft = root.m_171324_(INPUTLEFT);
        this.inputRight = root.m_171324_(INPUTRIGHT);
        this.inputBottom = root.m_171324_(INPUTBOTTOM);
        this.inputTop = root.m_171324_(INPUTTOP);
        this.outputLeft = root.m_171324_(OUTPUTLEFT);
        this.outputRight = root.m_171324_(OUTPUTRIGHT);
        this.outputBottom = root.m_171324_(OUTPUTBOTTOM);
        this.outputTop = root.m_171324_(OUTPUTTOP);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(INPUTLEFT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171517_("inputLeft_0", -4.0f, -12.0f, -6.0f, 4.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(INPUTRIGHT, CubeListBuilder.m_171558_().m_171514_(10, 0).m_171517_("inputRight_0", 0.0f, -12.0f, -6.0f, 4.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(INPUTBOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 9).m_171517_("inputBottom_0", -4.0f, -8.0f, -5.0f, 8.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(INPUTTOP, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171517_("inputTop_0", -4.0f, -12.0f, -5.0f, 8.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(OUTPUTLEFT, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171517_("outputLeft_0", -4.0f, -12.0f, 5.0f, 4.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(OUTPUTRIGHT, CubeListBuilder.m_171558_().m_171514_(10, 19).m_171517_("outputRight_0", 0.0f, -12.0f, 5.0f, 4.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(OUTPUTBOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 9).m_171517_("outputBottom_0", -4.0f, -8.0f, 4.0f, 8.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_(OUTPUTTOP, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171517_("outputTop_0", -4.0f, -12.0f, 4.0f, 8.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Override
    public void renderModel(PressureChamberInterfaceBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)Textures.MODEL_PRESSURE_CHAMBER_INTERFACE));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        float inputProgress = Mth.m_14179_((float)partialTicks, (float)te.oldInputProgress, (float)te.inputProgress) / 40.0f;
        float outputProgress = Mth.m_14179_((float)partialTicks, (float)te.oldOutputProgress, (float)te.outputProgress) / 40.0f;
        if (inputProgress <= 1.0f) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_((double)((1.0f - (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f) + 0.25, 0.0, 0.0);
            this.inputLeft.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_((double)((-1.0f + (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f) - 0.25, 0.0, 0.0);
            this.inputRight.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, (1.0f - (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f, 0.0f);
            this.inputBottom.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, (-1.0f + (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f, 0.0f);
            this.inputTop.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
        if (outputProgress < 1.0f) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_((double)((1.0f - (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f) + 0.25, 0.0, 0.0);
            this.outputLeft.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_((double)((-1.0f + (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f) - 0.25, 0.0, 0.0);
            this.outputRight.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, (1.0f - (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f, 0.0f);
            this.outputBottom.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, (-1.0f + (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f, 0.0f);
            this.outputTop.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
    }

    @Override
    protected void renderExtras(PressureChamberInterfaceBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!te.getStackInInterface().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedModel = itemRenderer.m_174264_(te.getStackInInterface(), te.m_58904_(), null, 0);
            itemRenderer.m_115143_(te.getStackInInterface(), ItemDisplayContext.GROUND, true, matrixStack, buffer, combinedLightIn, combinedOverlayIn, bakedModel);
            matrixStack.m_85849_();
        }
    }
}

