/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.tubemodule.SimpleThermostatModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetColorSelector;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.joml.Matrix4f;

public class ThermostatModuleScreen
extends AbstractTubeModuleScreen<ThermostatModule> {
    private int color;
    WidgetColorSelector colorSelector;
    private EditBox lowerBoundField;
    private EditBox higherBoundField;
    private int graphLowY;
    private int graphHighY;
    private int graphLeft;
    private int graphRight;
    private Rect2i lowerBoundArea;
    private Rect2i higherBoundArea;
    private boolean grabLower;
    private boolean grabHigher;

    public static AbstractTubeModuleScreen<?> createGUI(AbstractTubeModule module) {
        return module.isUpgraded() ? new ThermostatModuleScreen((ThermostatModule)module) : new SimpleThermostatModuleScreen((ThermostatModule)module);
    }

    public ThermostatModuleScreen(ThermostatModule module) {
        super(module);
        this.ySize = 191;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.color = ((ThermostatModule)this.module).getColorChannel();
        this.addLabel(this.m_96636_(), this.guiLeft + this.xSize / 2, this.guiTop + 5, WidgetLabel.Alignment.CENTRE);
        int xStart = (this.f_96543_ - this.xSize) / 2;
        int yStart = (this.f_96544_ - this.ySize) / 2;
        int x = this.guiLeft + 10;
        int y = this.guiTop + 22;
        WidgetLabel colorLabel = new WidgetLabel(x, y, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.channel", new Object[0]));
        this.m_142416_((GuiEventListener)colorLabel);
        x = this.guiLeft + 10 + colorLabel.m_5711_() + 7;
        this.colorSelector = new WidgetColorSelector(x, y - 2, w -> {
            this.color = w.getColor().m_41060_();
            ((ThermostatModule)this.module).setColorChannel(this.color);
            NetworkHandler.sendToServer(new PacketSyncThermostatModuleToServer((ThermostatModule)this.module));
        }).withInitialColor(DyeColor.m_41053_((int)this.color));
        this.m_142416_((GuiEventListener)this.colorSelector);
        x = this.guiLeft + 10 + colorLabel.m_5711_() + 7 + this.colorSelector.m_5711_() + 10;
        WidgetCheckBox advancedMode = new WidgetCheckBox(x, y, -12566464, (Component)Component.m_237113_((String)"Advanced"), b -> {
            ((ThermostatModule)this.module).advancedConfig = b.checked;
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
        }).setChecked(true);
        advancedMode.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.advancedConfig.tooltip", new Object[0])));
        this.m_142416_((GuiEventListener)advancedMode);
        this.addLabel((Component)Component.m_237113_((String)"lower"), this.guiLeft + 15, this.guiTop + 33);
        this.addLabel((Component)Component.m_237113_((String)"\u00b0C"), this.guiLeft + 60, this.guiTop + 44);
        this.addLabel((Component)Component.m_237113_((String)"higher"), this.guiLeft + 140, this.guiTop + 33);
        this.addLabel(this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.guiTop + 5);
        this.lowerBoundField = new EditBox(this.f_96547_, xStart + 15, yStart + 43, 40, 10, (Component)Component.m_237113_((String)PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).lowerBound, 0)));
        this.lowerBoundField.m_94151_(s -> this.updateBoundFromTextfield(0));
        this.m_142416_((GuiEventListener)this.lowerBoundField);
        this.higherBoundField = new EditBox(this.f_96547_, xStart + 130, yStart + 43, 40, 10, (Component)Component.m_237113_((String)PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).higherBound, 0)));
        this.higherBoundField.m_94151_(s -> this.updateBoundFromTextfield(1));
        this.m_142416_((GuiEventListener)this.higherBoundField);
        this.graphLowY = this.guiTop + 158;
        this.graphHighY = this.guiTop + 98;
        this.graphLeft = this.guiLeft + 22;
        this.graphRight = this.guiLeft + 172;
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.graphLeft - 20, this.graphHighY, 25, this.graphLowY - this.graphHighY, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstone", new Object[0])}));
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.graphLeft, this.graphLowY - 5, this.graphRight - this.graphLeft, 25, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.temperature", new Object[0])}));
        WidgetAnimatedStat stat = new WidgetAnimatedStat(this, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), WidgetAnimatedStat.StatIcon.of(Textures.GUI_INFO_LOCATION), xStart, yStart + 5, -7829249, null, true);
        stat.setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.tubeModule", new Object[0]));
        stat.setBeveled(true);
        this.m_142416_(stat);
        this.higherBoundArea = new Rect2i(this.guiLeft + 11, this.guiTop + 59, 158, 15);
        this.lowerBoundArea = new Rect2i(this.guiLeft + 11, this.guiTop + 73, 158, 15);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_TUBE_MODULE;
    }

    @Override
    public void drawForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int scrollbarLowerBoundX = this.temperatureToX((int)((ThermostatModule)this.module).lowerBound);
        int scrollbarHigherBoundX = this.temperatureToX((int)((ThermostatModule)this.module).higherBound);
        graphics.m_280218_(this.getTexture(), scrollbarLowerBoundX, this.guiTop + 73, 183, 0, 15, 12);
        graphics.m_280218_(this.getTexture(), scrollbarHigherBoundX, this.guiTop + 59, 183, 0, 15, 12);
        this.renderGraph(graphics);
        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
        NetworkHandler.sendToServer(new PacketSyncThermostatModuleToServer((ThermostatModule)this.module));
        graphics.m_280656_(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - ((ThermostatModule)this.module).getInputLevel()) / 15, -65536);
        String status = I18n.m_118938_((String)"pneumaticcraft.gui.tubeModule.simpleConfig.temperature", (Object[])new Object[0]) + " " + PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).getTemperature(), 0) + " \u00b0C";
        graphics.drawString(this.f_96547_, status, (float)this.guiLeft + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(status) / 2.0f, (float)(this.guiTop + 175), -12566464, false);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f posMat = graphics.m_280168_().m_85850_().m_252922_();
        float temperatureRange = 2273.0f;
        for (int i = 0; i < 16; ++i) {
            float y = (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f;
            float x = (float)this.graphLeft + (float)((this.graphRight - this.graphLeft) * (((ThermostatModule)this.module).getTemperatureForLevel(i) - -273)) / temperatureRange;
            bufferBuilder.m_252986_(posMat, x, y, 90.0f).m_85950_(0.25f + (float)i * 0.05f, 0.0f, 0.0f, 1.0f).m_5752_();
        }
        Tesselator.m_85913_().m_85914_();
        RenderSystem.disableBlend();
    }

    private void renderGraph(GuiGraphics graphics) {
        graphics.m_280315_(this.graphLeft, this.graphHighY, this.graphLowY, -13619152);
        for (int i = 0; i < 16; ++i) {
            boolean longer;
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                String txt = String.valueOf(i);
                graphics.drawString(this.f_96547_, txt, (float)(this.graphLeft - 5 - this.f_96547_.m_92895_(txt)), (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f - 3.0f, -13619152, false);
                graphics.m_280656_(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, i == 0 ? -13619152 : 0x33000000);
            }
            graphics.m_280656_(this.graphLeft - (longer ? 5 : 3), this.graphLeft + 3, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, -13619152);
        }
        int[] temps = new int[]{-273, 0, 1000, 2000};
        int[] adjusts = new int[]{-3, 1, 1, -5};
        for (int i = 0; i < 4; ++i) {
            int offset = (int)((float)(temps[i] - -273) * 0.04399472f);
            String txt = String.valueOf(temps[i]);
            graphics.drawString(this.f_96547_, txt, (float)this.graphLeft + (float)((this.graphRight - this.graphLeft) * offset) / 100.0f - (float)this.f_96547_.m_92895_(txt) / 2.0f + (float)adjusts[i], (float)(this.graphLowY + 6), -13619152, false);
            graphics.m_280315_(this.graphLeft + (this.graphRight - this.graphLeft) * offset / 100, this.graphHighY, this.graphLowY - 2, 0x33000000);
            graphics.m_280315_(this.graphLeft + (this.graphRight - this.graphLeft) * offset / 100, this.graphLowY - 5, this.graphLowY + 3, -13619152);
        }
    }

    private void updateBoundFromTextfield(int fieldId) {
        try {
            switch (fieldId) {
                case 0: {
                    float prev = ((ThermostatModule)this.module).lowerBound;
                    ((ThermostatModule)this.module).lowerBound = Mth.m_14045_((int)Integer.parseInt(this.lowerBoundField.m_94155_()), (int)-273, (int)2000);
                    if (!Mth.m_14033_((float)((ThermostatModule)this.module).lowerBound, (float)prev)) {
                        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
                    }
                    break;
                }
                case 1: {
                    float prev = ((ThermostatModule)this.module).higherBound;
                    ((ThermostatModule)this.module).higherBound = Mth.m_14045_((int)Integer.parseInt(this.higherBoundField.m_94155_()), (int)-273, (int)2000);
                    if (!Mth.m_14033_((float)((ThermostatModule)this.module).higherBound, (float)prev)) {
                        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown field id " + fieldId);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private int xToTemperature(double mouseX) {
        float sliderWidth = 146.0f;
        int sliderLeft = this.guiLeft + 11;
        float temperatureRange = 2273.0f;
        float xNormalized = Math.max(0.0f, Math.min(1.0f, ((float)mouseX - (float)sliderLeft) / sliderWidth));
        int temperature = (int)(xNormalized * temperatureRange) + -273;
        return temperature;
    }

    private int temperatureToX(int temperature) {
        float sliderWidth = 146.0f;
        int sliderLeft = this.guiLeft + 11;
        float temperatureRange = 2273.0f;
        float tempNormalized = Math.max(-273.0f, Math.min(2000.0f, ((float)temperature - -273.0f) / temperatureRange));
        int x = (int)(tempNormalized * sliderWidth) + sliderLeft;
        return x;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (!this.colorSelector.isExpanded() && this.lowerBoundArea.m_110087_((int)mouseX, (int)mouseY)) {
            ((ThermostatModule)this.module).lowerBound = this.xToTemperature(mouseX - 7.0);
            this.grabLower = true;
            return true;
        }
        if (!this.colorSelector.isExpanded() && this.higherBoundArea.m_110087_((int)mouseX, (int)mouseY)) {
            ((ThermostatModule)this.module).higherBound = this.xToTemperature(mouseX - 7.0);
            this.grabHigher = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.grabLower) {
            ((ThermostatModule)this.module).lowerBound = this.xToTemperature(mouseX - 7.0);
            return true;
        }
        if (this.grabHigher) {
            ((ThermostatModule)this.module).higherBound = this.xToTemperature(mouseX - 7.0);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (this.grabLower) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
            this.grabLower = false;
            return true;
        }
        if (this.grabHigher) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
            this.grabHigher = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (!((ThermostatModule)this.module).advancedConfig) {
            this.f_96541_.m_91152_((Screen)new SimpleThermostatModuleScreen((ThermostatModule)this.module));
        }
        if (!this.lowerBoundField.m_93696_()) {
            this.lowerBoundField.m_94144_(PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).lowerBound, 0));
        }
        if (!this.higherBoundField.m_93696_()) {
            this.higherBoundField.m_94144_(PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).higherBound, 0));
        }
    }
}

