/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.pneumatic_armor;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.ApiStatus;

public interface IArmorUpgradeHandler<T extends IArmorExtensionData> {
    public static final String UPGRADE_PREFIX = "pneumaticcraft.armor.upgrade.";

    public ResourceLocation getID();

    @ApiStatus.Internal
    public int getIndex();

    @ApiStatus.Internal
    public void setIndex(int var1);

    public PNCUpgrade[] getRequiredUpgrades();

    default public int getMaxInstallableUpgrades(PNCUpgrade upgrade) {
        return 1;
    }

    public float getIdleAirUsage(ICommonArmorHandler var1);

    default public float getMinimumPressure() {
        return 0.0f;
    }

    public EquipmentSlot getEquipmentSlot();

    default public String getTranslationKey() {
        return IArmorUpgradeHandler.getStringKey(this.getID());
    }

    default public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
    }

    default public void onInit(ICommonArmorHandler commonArmorHandler) {
    }

    default public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
    }

    default public void onShutdown(ICommonArmorHandler commonArmorHandler) {
    }

    default public void onDataFieldUpdated(ICommonArmorHandler commonArmorHandler, String tagName, Tag inbt) {
    }

    @Nonnull
    default public Supplier<T> extensionData() {
        return () -> null;
    }

    public static String getStringKey(ResourceLocation id) {
        return UPGRADE_PREFIX + (id.m_135827_().equals("pneumaticcraft") ? id.m_135815_() : id.toString().replace(':', '.'));
    }
}

