/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class HeatBehaviour
implements INBTSerializable<CompoundTag> {
    private IHeatExchangerLogic connectedHeatLogic;
    private Level world;
    private BlockPos pos;
    private BlockEntity cachedTE;
    private BlockState blockState;
    private Direction direction;

    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, Level world, BlockPos pos, Direction direction) {
        this.connectedHeatLogic = connectedHeatLogic;
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.cachedTE = null;
        this.blockState = null;
        return this;
    }

    public IHeatExchangerLogic getHeatExchanger() {
        return this.connectedHeatLogic;
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockEntity getCachedTileEntity() {
        if (this.cachedTE == null || this.cachedTE.m_58901_()) {
            this.cachedTE = this.world.m_7702_(this.pos);
        }
        return this.cachedTE;
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.world.m_8055_(this.pos);
        }
        return this.blockState;
    }

    public abstract ResourceLocation getId();

    public abstract boolean isApplicable();

    public abstract void tick();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("BlockPos"));
    }

    public boolean equals(Object o) {
        if (o instanceof HeatBehaviour) {
            HeatBehaviour behaviour = (HeatBehaviour)o;
            return behaviour.getId().equals((Object)this.getId()) && behaviour.getPos().equals((Object)this.getPos());
        }
        return false;
    }

    public int hashCode() {
        int i = this.getId().hashCode();
        i = i * 31 + this.getPos().hashCode();
        return i;
    }
}

