/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.api.IBaguPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SyncEntityPacketToServer {
    private final UUID uuid;

    public SyncEntityPacketToServer(UUID uuid) {
        this.uuid = uuid;
    }

    public static void writeToPacket(SyncEntityPacketToServer packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.uuid);
    }

    public static SyncEntityPacketToServer readFromPacket(FriendlyByteBuf buf) {
        return new SyncEntityPacketToServer(buf.m_130259_());
    }

    public static void handle(SyncEntityPacketToServer message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                Entity entity = ((ServerLevel)player.m_9236_()).m_8791_(message.uuid);
                if (entity instanceof IBaguPacket) {
                    IBaguPacket baguPacket = (IBaguPacket)entity;
                    baguPacket.resync(entity, entity.m_19879_());
                }
            });
        }
        context.setPacketHandled(true);
    }
}

