/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.client.camera.CameraEvent;
import bagu_chan.bagus_lib.client.camera.CameraHolder;
import bagu_chan.bagus_lib.util.GlobalVec3;
import bagu_chan.bagus_lib.util.GlobalVec3ByteBuf;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class CameraMessage {
    private final int duration;
    private final int distance;
    private final float amount;
    private final GlobalVec3 globalPos;

    public CameraMessage(int distance, int duration, float amount, GlobalVec3 globalPos) {
        this.distance = distance;
        this.duration = duration;
        this.amount = amount;
        this.globalPos = globalPos;
    }

    public static void writeToPacket(CameraMessage packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.distance);
        buf.writeInt(packet.duration);
        buf.writeFloat(packet.amount);
        GlobalVec3ByteBuf.writeGlobalPos(buf, packet.globalPos);
    }

    public static CameraMessage readFromPacket(FriendlyByteBuf buf) {
        return new CameraMessage(buf.readInt(), buf.readInt(), buf.readFloat(), GlobalVec3ByteBuf.readGlobalPos(buf));
    }

    public static void handle(CameraMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            Level level = Minecraft.m_91087_().f_91074_.m_9236_();
            if (level == null) {
                return;
            }
            CameraEvent.addCameraHolderList(level, new CameraHolder(message.distance, message.duration, message.amount, message.globalPos));
        });
        ctx.get().setPacketHandled(true);
    }
}

