/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.egg;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlockEntity;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class HatchableEggBlock
extends DragonEggBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty HATCH_STAGE = IntegerProperty.m_61631_((String)"hatch_stage", (int)0, (int)3);
    public static final BooleanProperty HATCHING = BooleanProperty.m_61465_((String)"hatching");
    public static final float DEFAULT_HATCH_CHANCE = 0.1f;
    public static final String NBT_HATCH_STAGE = "hatch_stage";
    public static final String NBT_BREED = "Breed";
    public static final String NBT_NAME = "CustomName";

    public HatchableEggBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60913_(0.0f, 9.0f).m_60953_(s -> 1).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HATCH_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HATCHING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH_STAGE, HATCHING, BlockStateProperties.f_61362_});
    }

    public static void populateTab(Consumer<ItemStack> registrar) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            RegistryAccess reg = Minecraft.m_91087_().f_91073_.m_9598_();
            for (DragonBreed breed : BreedRegistry.registry(reg)) {
                registrar.accept(Item.create(breed, reg));
            }
        }
    }

    public static HatchableEggBlockEntity place(ServerLevel level, BlockPos pos, BlockState state, DragonBreed breed) {
        level.m_7731_(pos, state, 3);
        HatchableEggBlockEntity data = (HatchableEggBlockEntity)((HatchableEggBlock)state.m_60734_()).m_142194_(pos, state);
        data.setBreed(() -> breed);
        level.m_151523_((BlockEntity)data);
        return data;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new HatchableEggBlockEntity(pPos, pState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        HatchableEggBlockEntity e;
        BlockEntity blockEntity = level.m_7702_(pos);
        DragonBreed breed = blockEntity instanceof HatchableEggBlockEntity && (e = (HatchableEggBlockEntity)blockEntity).hasBreed() ? e.getBreed() : BreedRegistry.getRandom(player.m_9236_().m_9598_(), player.m_217043_());
        return Item.create(breed, player.m_9236_().m_9598_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level _level, BlockState _state, BlockEntityType<T> type) {
        return type != DMLRegistry.EGG_BLOCK_ENTITY.get() ? null : (BlockEntityTicker)HatchableEggBlock.cast((level, pos, state, be) -> be.tick(level, pos, state));
    }

    private static <F extends BlockEntityTicker<HatchableEggBlockEntity>, T> T cast(F from) {
        return (T)from;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!((Boolean)pState.m_61143_((Property)HATCHING)).booleanValue()) {
            if (!pLevel.f_46443_) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HATCHING, (Comparable)Boolean.valueOf(true)), 3);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6256_(BlockState state, Level level, BlockPos at, Player pPlayer) {
        HatchableEggBlockEntity e;
        BlockEntity blockEntity = level.m_7702_(at);
        if (blockEntity instanceof HatchableEggBlockEntity && (e = (HatchableEggBlockEntity)blockEntity).hasBreed() && e.getBreed().id(level.m_9598_()).m_135815_().equals("end") && !((Boolean)state.m_61143_((Property)HATCHING)).booleanValue()) {
            HatchableEggBlock.m_52935_(state, level, at);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos at, Player player, boolean willHarvest, FluidState fluid) {
        HatchableEggBlockEntity e;
        BlockEntity blockEntity;
        if (!player.m_150110_().f_35937_ && (blockEntity = level.m_7702_(at)) instanceof HatchableEggBlockEntity && (e = (HatchableEggBlockEntity)blockEntity).hasBreed() && e.getBreed().id(level.m_9598_()).m_135815_().equals("end") && !((Boolean)state.m_61143_((Property)HATCHING)).booleanValue()) {
            return false;
        }
        return super.onDestroyedByPlayer(state, level, at, player, willHarvest, fluid);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltips, TooltipFlag pFlag) {
        super.m_5871_(stack, level, tooltips, pFlag);
        CompoundTag tag = stack.m_41737_("BlockStateTag");
        String stage = tag != null ? tag.m_128461_(NBT_HATCH_STAGE) : "0";
        tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".hatch_stage." + stage)).m_130940_(ChatFormatting.GRAY));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_150110_().f_35937_) {
            tooltips.add(CommonComponents.f_237098_);
            tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".desc1")).m_130940_(ChatFormatting.GRAY));
            tooltips.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237115_((String)(this.m_7705_() + ".desc2"))).m_130940_(ChatFormatting.BLUE));
        }
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, pDirection, pNeighborState, level, pCurrentPos, pNeighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (HatchableEggBlock.m_53241_((BlockState)pLevel.m_8055_(pPos.m_7495_())) && pPos.m_123342_() >= pLevel.m_141937_()) {
            CompoundTag tag = null;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof HatchableEggBlockEntity) {
                HatchableEggBlockEntity e = (HatchableEggBlockEntity)blockEntity;
                tag = e.m_187482_();
            }
            FallingBlockEntity entity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (tag != null) {
                entity.f_31944_ = tag;
            }
            this.m_6788_(entity);
        }
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)HATCHING);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean finalStage;
        HatchableEggBlockEntity data;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof HatchableEggBlockEntity) || !(data = (HatchableEggBlockEntity)blockEntity).hasBreed()) {
            return;
        }
        int hatchStage = (Integer)state.m_61143_((Property)HATCH_STAGE);
        boolean bl = finalStage = hatchStage == 3;
        if (random.m_188501_() < data.getBreed().hatchChance()) {
            if (finalStage) {
                this.hatch(level, pos);
            } else {
                this.crack(level, pos);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH_STAGE, (Comparable)Integer.valueOf(hatchStage + 1)), 3);
            }
            return;
        }
        if (finalStage) {
            this.crack(level, pos);
        } else if (DMLConfig.updateHabitats() && !data.getTransition().isRunning()) {
            data.updateHabitat();
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource random) {
        HatchableEggBlockEntity e;
        BlockEntity blockEntity;
        if (((Boolean)pState.m_61143_((Property)HATCHING)).booleanValue() && (blockEntity = pLevel.m_7702_(pPos)) instanceof HatchableEggBlockEntity && (e = (HatchableEggBlockEntity)blockEntity).hasBreed()) {
            for (int i = 0; i < random.m_216332_(4, 7); ++i) {
                this.addHatchingParticles(e.getBreed(), pLevel, pPos, random);
            }
        }
    }

    private void crack(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.85f, 0.95f + level.m_213780_().m_188501_() * 0.2f);
    }

    private void hatch(ServerLevel level, BlockPos pos) {
        HatchableEggBlockEntity data = (HatchableEggBlockEntity)level.m_7702_(pos);
        TameableDragon baby = (TameableDragon)((EntityType)DMLRegistry.DRAGON.get()).m_20615_((Level)level);
        level.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 1.2f, 0.95f + level.m_213780_().m_188501_() * 0.2f);
        level.m_7471_(pos, false);
        baby.setBreed(data.getBreed());
        baby.m_6863_(true);
        baby.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        baby.m_6593_(data.m_7770_());
        level.m_7967_((Entity)baby);
    }

    public void addHatchingParticles(DragonBreed breed, Level level, BlockPos pos, RandomSource random) {
        double px = (double)pos.m_123341_() + random.m_188500_();
        double py = (double)pos.m_123342_() + random.m_188500_();
        double pz = (double)pos.m_123343_() + random.m_188500_();
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        ParticleOptions particle = HatchableEggBlock.getHatchingParticles(breed, random);
        if (particle.m_6012_() == ParticleTypes.f_123805_) {
            py = (double)pos.m_123342_() + (random.m_188500_() - 0.5) + 1.0;
        } else if (particle.m_6012_() == ParticleTypes.f_123760_) {
            ox = (random.m_188500_() - 0.5) * 2.0;
            oy = (random.m_188500_() - 0.5) * 2.0;
            oz = (random.m_188500_() - 0.5) * 2.0;
        }
        level.m_7106_(particle, px, py, pz, ox, oy, oz);
    }

    public static ParticleOptions getHatchingParticles(DragonBreed breed, RandomSource random) {
        return breed.hatchParticles().orElseGet(() -> HatchableEggBlock.dustParticleFor(breed, random));
    }

    public static DustParticleOptions dustParticleFor(DragonBreed breed, RandomSource random) {
        return new DustParticleOptions(Vec3.m_82501_((int)(random.m_188500_() < 0.75 ? breed.primaryColor() : breed.secondaryColor())).m_252839_(), 1.0f);
    }

    private static void m_52935_(BlockState state, Level level, BlockPos pos) {
        WorldBorder worldBorder = level.m_6857_();
        for (int i = 0; i < 1000; ++i) {
            BlockPos teleportPos = pos.m_7918_(level.f_46441_.m_188503_(16) - level.f_46441_.m_188503_(16), level.f_46441_.m_188503_(8) - level.f_46441_.m_188503_(8), level.f_46441_.m_188503_(16) - level.f_46441_.m_188503_(16));
            if (!level.m_8055_(teleportPos).m_60795_() || !worldBorder.m_61937_(teleportPos)) continue;
            if (level.f_46443_) {
                for (int j = 0; j < 128; ++j) {
                    double d0 = level.f_46441_.m_188500_();
                    float f = (level.f_46441_.m_188501_() - 0.5f) * 0.2f;
                    float f1 = (level.f_46441_.m_188501_() - 0.5f) * 0.2f;
                    float f2 = (level.f_46441_.m_188501_() - 0.5f) * 0.2f;
                    double d1 = Mth.m_14139_((double)d0, (double)teleportPos.m_123341_(), (double)pos.m_123341_()) + (level.f_46441_.m_188500_() - 0.5) + 0.5;
                    double d2 = Mth.m_14139_((double)d0, (double)teleportPos.m_123342_(), (double)pos.m_123342_()) + level.f_46441_.m_188500_() - 0.5;
                    double d3 = Mth.m_14139_((double)d0, (double)teleportPos.m_123343_(), (double)pos.m_123343_()) + (level.f_46441_.m_188500_() - 0.5) + 0.5;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, (double)f, (double)f1, (double)f2);
                }
            } else {
                CompoundTag data = level.m_7702_(pos).m_187482_();
                level.m_7471_(pos, false);
                level.m_7731_(teleportPos, state, 2);
                level.m_7702_(teleportPos).m_142466_(data);
            }
            return;
        }
    }

    public static class Item
    extends BlockItem {
        public Item() {
            super((Block)DMLRegistry.EGG_BLOCK.get(), new Item.Properties().m_41497_(Rarity.EPIC));
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            Item.ensureExistingBreedType(stack);
            return super.initCapabilities(stack, nbt);
        }

        public Component m_7626_(ItemStack stack) {
            CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
            if (tag != null) {
                return Component.m_237115_((String)String.join((CharSequence)".", this.m_5524_(), tag.m_128461_(HatchableEggBlock.NBT_BREED).replace(':', '.')));
            }
            return super.m_7626_(stack);
        }

        public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
            if (player.m_150110_().f_35937_ && target instanceof TameableDragon) {
                TameableDragon dragon = (TameableDragon)target;
                CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
                if (tag != null) {
                    dragon.setBreed(BreedRegistry.get(tag.m_128461_(HatchableEggBlock.NBT_BREED), player.m_9236_().m_9598_()));
                    return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
                }
            }
            return super.m_6880_(stack, player, target, hand);
        }

        public InteractionResult m_40576_(BlockPlaceContext pContext) {
            BlockEntity blockEntity;
            InteractionResult result = super.m_40576_(pContext);
            if (result.m_19077_() && pContext.m_43722_().m_41788_() && (blockEntity = pContext.m_43725_().m_7702_(pContext.m_8083_())) instanceof HatchableEggBlockEntity) {
                HatchableEggBlockEntity e = (HatchableEggBlockEntity)blockEntity;
                e.setCustomName(pContext.m_43722_().m_41786_());
            }
            return result;
        }

        private static void ensureExistingBreedType(ItemStack stack) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return;
            }
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            CompoundTag blockEntityData = stack.m_41698_("BlockEntityTag");
            String breed = blockEntityData.m_128461_(HatchableEggBlock.NBT_BREED);
            Registry<DragonBreed> reg = BreedRegistry.registry((RegistryAccess)ServerLifecycleHooks.getCurrentServer().m_206579_());
            if (breed.isEmpty() || !reg.m_7804_(new ResourceLocation(breed))) {
                breed = ((Holder.Reference)reg.m_213642_(RandomSource.m_216327_()).orElseThrow()).m_205785_().m_135782_().toString();
                blockEntityData.m_128359_(HatchableEggBlock.NBT_BREED, breed);
            }
        }

        public static ItemStack create(DragonBreed breed, RegistryAccess reg) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(HatchableEggBlock.NBT_BREED, breed.id(reg).toString());
            ItemStack stack = new ItemStack((ItemLike)DMLRegistry.EGG_BLOCK_ITEM.get());
            BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)DMLRegistry.EGG_BLOCK_ENTITY.get()), (CompoundTag)tag);
            return stack;
        }
    }
}

