/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class DragonSpawnEgg
extends ForgeSpawnEggItem {
    private static final String DATA_TAG = "ItemData";
    private static final String DATA_ITEM_NAME = "ItemName";
    private static final String DATA_PRIM_COLOR = "PrimaryColor";
    private static final String DATA_SEC_COLOR = "SecondaryColor";

    public DragonSpawnEgg() {
        super(DMLRegistry.DRAGON, 0, 0, new Item.Properties());
    }

    public static ItemStack create(DragonBreed breed, RegistryAccess reg) {
        ResourceLocation id = breed.id(reg);
        CompoundTag root = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128359_("Breed", id.toString());
        root.m_128365_("EntityTag", (Tag)entityTag);
        CompoundTag itemDataTag = new CompoundTag();
        itemDataTag.m_128359_(DATA_ITEM_NAME, String.join((CharSequence)".", ((Item)DMLRegistry.SPAWN_EGG.get()).m_5524_(), id.m_135827_(), id.m_135815_()));
        itemDataTag.m_128405_(DATA_PRIM_COLOR, breed.primaryColor());
        itemDataTag.m_128405_(DATA_SEC_COLOR, breed.secondaryColor());
        root.m_128365_(DATA_TAG, (Tag)itemDataTag);
        ItemStack stack = new ItemStack((ItemLike)DMLRegistry.SPAWN_EGG.get());
        stack.m_41751_(root);
        return stack;
    }

    public static void populateTab(Consumer<ItemStack> registrar) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            RegistryAccess reg = Minecraft.m_91087_().f_91073_.m_9598_();
            for (DragonBreed breed : BreedRegistry.registry(reg)) {
                registrar.accept(DragonSpawnEgg.create(breed, reg));
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        DragonSpawnEgg.preconditionSpawnEgg(stack);
        return super.initCapabilities(stack, nbt);
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(DATA_TAG);
        if (tag != null && tag.m_128441_(DATA_ITEM_NAME)) {
            return Component.m_237115_((String)tag.m_128461_(DATA_ITEM_NAME));
        }
        return super.m_7626_(stack);
    }

    public Optional<Mob> m_43215_(Player pPlayer, Mob pMob, EntityType<? extends Mob> pEntityType, ServerLevel pServerLevel, Vec3 pPos, ItemStack pStack) {
        String breedID;
        CompoundTag entityTag = pStack.m_41737_("EntityTag");
        if (entityTag != null && !(breedID = entityTag.m_128461_("Breed")).isEmpty() && ((TameableDragon)pMob).getBreed() != BreedRegistry.get(breedID, pServerLevel.m_9598_())) {
            return Optional.empty();
        }
        return super.m_43215_(pPlayer, pMob, pEntityType, pServerLevel, pPos, pStack);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        CompoundTag tag = stack.m_41737_(DATA_TAG);
        if (tag != null) {
            return tintIndex == 0 ? tag.m_128451_(DATA_PRIM_COLOR) : tag.m_128451_(DATA_SEC_COLOR);
        }
        return 0xFFFFFF;
    }

    private static void preconditionSpawnEgg(ItemStack stack) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        CompoundTag root = stack.m_41784_();
        CompoundTag blockEntityData = stack.m_41698_("EntityTag");
        String breedId = blockEntityData.m_128461_("Breed");
        RegistryAccess.Frozen regAcc = ServerLifecycleHooks.getCurrentServer().m_206579_();
        Registry<DragonBreed> reg = BreedRegistry.registry((RegistryAccess)regAcc);
        if (breedId.isEmpty() || !reg.m_7804_(new ResourceLocation(breedId))) {
            Holder.Reference breed = (Holder.Reference)reg.m_213642_(RandomSource.m_216327_()).orElseThrow();
            ItemStack updated = DragonSpawnEgg.create((DragonBreed)breed.get(), (RegistryAccess)regAcc);
            root.m_128391_(updated.m_41783_());
        }
    }
}

