/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.abilities;

import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.abilities.FootprintAbility;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HydroStepAbility
extends FootprintAbility
implements Ability.Factory<HydroStepAbility> {
    public static final HydroStepAbility INSTANCE = new HydroStepAbility();
    public static final Codec<HydroStepAbility> CODEC = Codec.unit((Object)INSTANCE);

    @Override
    protected void placeFootprint(TameableDragon dragon, BlockPos pos) {
        Level level = dragon.m_9236_();
        BlockPos groundPos = pos.m_7495_();
        BlockState steppingOn = level.m_8055_(groundPos);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10, 0.25, 0.0, 0.25, 0.0);
        if (steppingOn.m_60713_(Blocks.f_50093_)) {
            level.m_46597_(groundPos, (BlockState)steppingOn.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)));
            return;
        }
        if (steppingOn.m_60713_(Blocks.f_50056_)) {
            level.m_46597_(groundPos, Blocks.f_50057_.m_49966_());
            return;
        }
        if (steppingOn.m_60713_(Blocks.f_50450_)) {
            level.m_46597_(groundPos, Blocks.f_50730_.m_49966_());
            return;
        }
        ResourceLocation steppingOnName = steppingOn.m_60734_().m_204297_().m_205785_().m_135782_();
        if (steppingOnName.m_135827_().equals("minecraft") && steppingOnName.m_135815_().contains("copper")) {
            WeatheringCopper.m_154904_((Block)steppingOn.m_60734_()).ifPresent(b -> level.m_46597_(groundPos, b.m_152465_(steppingOn)));
            return;
        }
        if (level.m_8055_(pos).m_204336_(BlockTags.f_13076_)) {
            level.m_7471_(pos, false);
            return;
        }
    }

    @Override
    protected float getFootprintChance(TameableDragon dragon) {
        return 1.0f;
    }

    @Override
    public HydroStepAbility create() {
        return this;
    }

    @Override
    public ResourceLocation type() {
        return HYDRO_STEP;
    }
}

