/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.abilities;

import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class FrostWalkerAbility
implements Ability,
Ability.Factory<FrostWalkerAbility> {
    public static final Codec<FrostWalkerAbility> CODEC = Codec.FLOAT.xmap(FrostWalkerAbility::new, a -> Float.valueOf(a.radiusMultiplier)).fieldOf("radius_multiplier").codec();
    private final float radiusMultiplier;

    protected FrostWalkerAbility(float radiusMultiplier) {
        this.radiusMultiplier = radiusMultiplier;
    }

    public static FrostWalkerAbility create(float radiusMultiplier) {
        return new FrostWalkerAbility(radiusMultiplier);
    }

    @Override
    public void initialize(TameableDragon dragon) {
        dragon.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    public void close(TameableDragon dragon) {
        dragon.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WATER.m_77124_());
    }

    @Override
    public void tick(TameableDragon dragon) {
        Level level = dragon.m_9236_();
        if (dragon.f_19797_ % 3 != 0) {
            return;
        }
        if (level.m_5776_() || (double)dragon.getAgeProgress() < 0.5) {
            return;
        }
        int radius = (int)(Math.max(this.radiusMultiplier * dragon.m_6134_(), 1.0f) + 3.0f);
        BlockPos pos = dragon.m_20183_();
        for (BlockPos carat : BlockPos.m_121940_((BlockPos)pos.m_7918_(-radius, -2, -radius), (BlockPos)pos.m_7918_(radius, -1, radius))) {
            BlockPos.MutableBlockPos mPos;
            BlockState ice;
            BlockState currentState;
            if (!carat.m_203195_((Position)dragon.m_20182_(), (double)radius) || (currentState = level.m_8055_(carat)) != FrostedIceBlock.m_278844_() || ForgeEventFactory.onBlockPlace((Entity)dragon, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)carat), (Direction)Direction.UP) || !(ice = Blocks.f_50449_.m_49966_()).m_60710_((LevelReader)level, carat) || !level.m_45752_(ice, carat, CollisionContext.m_82749_()) || !level.m_8055_((BlockPos)(mPos = carat.m_122032_().m_122184_(0, 1, 0))).m_60795_()) continue;
            level.m_46597_(carat, ice);
            level.m_186460_(carat, Blocks.f_50449_, Mth.m_216271_((RandomSource)dragon.m_217043_(), (int)60, (int)120));
        }
    }

    @Override
    public FrostWalkerAbility create() {
        return this;
    }

    @Override
    public ResourceLocation type() {
        return FROST_WALKER;
    }
}

