/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.util.jei;

import com.gumillea.cosmopolitan.core.reg.CosmoBlocks;
import com.gumillea.cosmopolitan.core.reg.CosmoItems;
import com.gumillea.cosmopolitan.core.util.jei.HerbalCookieRecipeMaker;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CosmoJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("cosmopolitan", "jei_plugin");
    private static final List<Supplier<Item>> INFO_ITEMS = List.of(CosmoItems.FIDDLEHEAD, CosmoItems.WILDBERRY, CosmoItems.WHEATGRASS);

    public void registerRecipes(IRecipeRegistration registration) {
        List<CraftingRecipe> herbalCookie = HerbalCookieRecipeMaker.createRecipes();
        registration.addRecipes(RecipeTypes.CRAFTING, herbalCookie);
        for (Supplier<Item> itemSupplier : INFO_ITEMS) {
            Item item = itemSupplier.get();
            ResourceLocation key = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
            String translationKey = "jei.cosmopolitan." + key.m_135815_() + ".desc";
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)translationKey)});
        }
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)CosmoItems.GULIME.get()), new ItemStack((ItemLike)CosmoItems.UNDERGROUND_GULIME.get()), new ItemStack((ItemLike)CosmoItems.TAIGA_GULIME.get()), new ItemStack((ItemLike)CosmoItems.CHORUS_GULIME.get()), new ItemStack((ItemLike)CosmoItems.GULIME_SMALL.get()), new ItemStack((ItemLike)CosmoItems.UNDERGROUND_GULIME_SMALL.get()), new ItemStack((ItemLike)CosmoItems.TAIGA_GULIME_SMALL.get()), new ItemStack((ItemLike)CosmoItems.CHORUS_GULIME_SMALL.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.cosmopolitan.gulime.desc")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)CosmoItems.CONDENSED_MILK_BUCKET.get()), new ItemStack((ItemLike)CosmoItems.CONDENSED_MILK_BOTTLE.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.cosmopolitan.condensed_milk_bucket.desc")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)CosmoItems.CREAM_BUCKET.get()), new ItemStack((ItemLike)CosmoItems.CREAM.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.cosmopolitan.cream_bucket.desc")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)CosmoBlocks.COPPER_FROZEN_DESSERT_TUB.get()), new ItemStack((ItemLike)CosmoBlocks.IRON_FROZEN_DESSERT_TUB.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.cosmopolitan.frozen_dessert_tub.desc")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)CosmoItems.BERRY_DOUBLE_POPSICLE.get()), new ItemStack((ItemLike)CosmoItems.CHORUS_FRUIT_DOUBLE_POPSICLE.get()), new ItemStack((ItemLike)CosmoItems.LIME_DOUBLE_POPSICLE.get()), new ItemStack((ItemLike)CosmoItems.BLISTERBERRY_DOUBLE_POPSICLE.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.cosmopolitan.blisterberry_popsicle_double.desc")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)CosmoItems.WANDERING_GELATO.get()), new ItemStack((ItemLike)CosmoItems.TRAVELERS_PANINI.get()), new ItemStack((ItemLike)CosmoItems.LLAMA_MARSHMALLOW_TRADER.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.cosmopolitan.wandering_gelato.desc")});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

