/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.util;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.common.item.DoublePopsicleItem;
import com.gumillea.cosmopolitan.common.item.PottedCropItem;
import com.gumillea.cosmopolitan.common.item.WheatgrassItem;
import com.gumillea.cosmopolitan.core.reg.CosmoBlocks;
import com.gumillea.cosmopolitan.core.reg.CosmoEffects;
import com.gumillea.cosmopolitan.core.reg.CosmoItems;
import com.gumillea.cosmopolitan.core.util.CosmoBlockTags;
import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import com.gumillea.cosmopolitan.core.util.CosmoEffectTags;
import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import quek.undergarden.registry.UGDimensions;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;

@Mod.EventBusSubscriber(modid="cosmopolitan")
public class CosmoEvents {
    @SubscribeEvent
    public static void onEntityAttacked(LivingDamageEvent event) {
        Entity entity;
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        float amount = event.getAmount();
        if (target.m_21023_((MobEffect)CosmoEffects.INGRAINED.get()) && event.getSource() != target.m_269291_().m_269341_() && event.getSource() != target.m_269291_().m_269064_()) {
            double y = target.m_20186_();
            double maxHeight = target.m_9236_().m_151558_();
            int segment = (int)((1.0 - y / maxHeight) * 4.0);
            double reduction = (double)Math.max(0, Math.min(segment, 4)) * 0.05;
            event.setAmount((float)((double)amount * (1.0 - reduction)));
        }
        if (target.m_21023_((MobEffect)CosmoEffects.EXUBERANT.get())) {
            target.m_21195_((MobEffect)CosmoEffects.EXUBERANT.get());
            if (target instanceof Player) {
                Player player = (Player)target;
                player.m_5496_(SoundEvents.f_144068_, 1.5f, 1.0f);
            }
        }
        if ((entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (target.m_21023_((MobEffect)CosmoEffects.VARDOGER.get()) && (double)target.m_217043_().m_188501_() < (Double)CosmoConfig.Common.BLISTERBERRY_CHANCE.get()) {
                CosmoEvents.handleVardoger(target.m_9236_(), target, event);
            }
            if (attacker.m_21023_((MobEffect)CosmoEffects.VARDOGER.get()) && (double)attacker.m_217043_().m_188501_() < (Double)CosmoConfig.Common.BLISTERBERRY_CHANCE.get()) {
                CosmoEvents.handleVardoger(target.m_9236_(), target, event);
            }
            if (source.m_269014_() && source.m_7640_() instanceof Projectile && attacker.m_21023_((MobEffect)CosmoEffects.TRACER.get())) {
                int amplifier = Objects.requireNonNull(attacker.m_21124_((MobEffect)CosmoEffects.TRACER.get())).m_19564_() + 1;
                target.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.MARKED.get(), 300 * amplifier));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300 * amplifier));
                attacker.m_21195_((MobEffect)CosmoEffects.TRACER.get());
            }
        }
    }

    private static void handleVardoger(Level level, LivingEntity target, LivingDamageEvent event) {
        float amount = event.getAmount();
        target.m_5496_(SoundEvents.f_11880_, 1.5f, 1.0f);
        if (CosmoCompat.ug && level.m_46472_() == UGDimensions.UNDERGARDEN_LEVEL) {
            float power = amount < 10.0f ? amount / 2.0f : 5.0f;
            level.m_254849_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), power, Level.ExplosionInteraction.NONE);
        } else {
            event.setAmount(amount * 2.0f);
        }
    }

    @SubscribeEvent
    public static void onItemUsed(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        LivingEntity user = event.getEntity();
        if (user instanceof LivingEntity) {
            LivingEntity living = user;
            if (stack.m_41614_()) {
                int amplifier;
                int nutrition = Objects.requireNonNull(stack.getFoodProperties(living)).m_38744_();
                if (stack.m_41782_() && stack.m_41783_().m_128471_("has_cream")) {
                    int creamNutrition;
                    int n = creamNutrition = nutrition == 0 ? 1 : (int)Math.ceil((double)nutrition / 4.0);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        player.m_36324_().m_38707_(creamNutrition, 0.0f);
                    }
                }
                int duration = nutrition < 10 ? 300 : 600;
                int n = amplifier = nutrition < 10 ? 0 : 1;
                if (((Boolean)CosmoConfig.Common.APPLE_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.EXUBERANT_SOURCES)) {
                    duration = nutrition < 10 ? 10 - nutrition : 1;
                    living.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.EXUBERANT.get(), duration * 300));
                }
                if (((Boolean)CosmoConfig.Common.GLOW_BERRY_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.TRACER_SOURCES)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.TRACER.get(), duration, amplifier));
                }
                if (((Boolean)CosmoConfig.Common.DROOPFRUIT_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.ABYSMAL_TORCH_SOURCES)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.ABYSMAL_TORCH.get(), -1, amplifier));
                }
                if (((Boolean)CosmoConfig.Common.BLISTERBERRY_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.VARDOGER_SOURCES)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.VARDOGER.get(), (int)((double)duration * 1.5)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Applicable event) {
        ITagManager mobEffectTags;
        MobEffect effect = event.getEffectInstance().m_19544_();
        LivingEntity entity = event.getEntity();
        if (effect == CosmoEffects.PLACEHOLDER.get()) {
            event.setResult(Event.Result.DENY);
        }
        if (entity.m_21023_((MobEffect)CosmoEffects.CAROTENE.get()) && (mobEffectTags = ForgeRegistries.MOB_EFFECTS.tags()) != null && mobEffectTags.getTag(CosmoEffectTags.CONVERTIBLE_BY_CAROTENE).contains((Object)effect)) {
            for (int i = 0; i < 8; ++i) {
                double d0 = new Random().nextGaussian() * 0.02;
                double d1 = new Random().nextGaussian() * 0.02;
                double d2 = new Random().nextGaussian() * 0.02;
                entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
            }
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600));
            event.setResult(Event.Result.DENY);
        }
        if (effect == CosmoEffects.EXUBERANT.get()) {
            int d1 = event.getEffectInstance().m_19557_();
            float a1 = event.getEffectInstance().m_19564_();
            if (entity.m_21023_((MobEffect)CosmoEffects.EXUBERANT.get())) {
                int d2 = Objects.requireNonNull(entity.m_21124_((MobEffect)CosmoEffects.EXUBERANT.get())).m_19557_();
                float a2 = Objects.requireNonNull(entity.m_21124_((MobEffect)CosmoEffects.EXUBERANT.get())).m_19564_();
                if (a2 >= a1 && d2 < d1) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingKiller;
        LivingEntity target = event.getEntity();
        Level level = target.m_9236_();
        BlockPos pos = target.m_20097_().m_7494_();
        Entity killer = event.getSource().m_7639_();
        MobEffect at = (MobEffect)CosmoEffects.ABYSMAL_TORCH.get();
        if (target instanceof Monster && killer instanceof LivingEntity && (livingKiller = (LivingEntity)killer).m_21023_(at) && (level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_247087_())) {
            int amplifier = Objects.requireNonNull(livingKiller.m_21124_(at)).m_19564_();
            level.m_7731_(pos, ((Block)CosmoBlocks.LIFELIGHT.get()).m_49966_(), 3);
            level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223722_((BlockState)level.m_8055_(pos)));
            livingKiller.m_21195_(at);
            if (amplifier > 0) {
                livingKiller.m_7292_(new MobEffectInstance(at, -1, amplifier - 1));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Cat cat;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (player != null && item instanceof DoublePopsicleItem) {
            DoublePopsicleItem doublePopsicle = (DoublePopsicleItem)item;
            if (!player.m_36335_().m_41519_(item) && target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                FoodProperties food = item.m_41473_();
                if (food == null) {
                    return;
                }
                if (living instanceof Player) {
                    Player player1 = (Player)living;
                    player1.m_36324_().m_38707_(food.m_38744_() / 2, food.m_38745_());
                }
                living.m_146917_(living.m_146888_() + 80);
                living.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
                if (!food.m_38749_().isEmpty()) {
                    for (Pair effectPair : food.m_38749_()) {
                        MobEffectInstance doubleEffect = (MobEffectInstance)effectPair.getFirst();
                        MobEffectInstance effect = new MobEffectInstance(doubleEffect.m_19544_(), doubleEffect.m_19557_() / 2, doubleEffect.m_19564_());
                        living.m_7292_(effect);
                    }
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    ItemStack popsicle = new ItemStack((ItemLike)doublePopsicle.getResult().get());
                    if (!player.m_150109_().m_36054_(popsicle)) {
                        player.m_36176_(popsicle, false);
                    }
                }
                player.m_36335_().m_41524_(item, 80);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
        if (target instanceof Cat && (cat = (Cat)target).m_6084_() && cat.m_21824_() && stack.m_41720_() instanceof WheatgrassItem) {
            for (MobEffectInstance effect : WheatgrassItem.EFFECTS) {
                cat.m_7292_(new MobEffectInstance(effect));
            }
            cat.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
            for (int i = 0; i < 5; ++i) {
                double d0 = new Random().nextGaussian() * 0.02;
                double d1 = new Random().nextGaussian() * 0.02;
                double d2 = new Random().nextGaussian() * 0.02;
                cat.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, cat.m_20208_(1.0), cat.m_20187_() + 0.5, cat.m_20262_(1.0), d0, d1, d2);
            }
            if (player != null && !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Item item;
        Level level = event.getLevel();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack inHand = player.m_21120_(hand);
        BlockState state = level.m_8055_(event.getPos());
        BlockPos pos = event.getPos();
        Block block = state.m_60734_();
        if (!level.f_46443_ && inHand.m_41720_() instanceof AxeItem) {
            Season season;
            if (CosmoCompat.ss && ModConfig.fertility.seasonalCrops && (season = SeasonHelper.getSeasonState((Level)level).getSeason()) != Season.SPRING && season != Season.WINTER) {
                return;
            }
            if (block == Blocks.f_50001_ && (double)level.m_213780_().m_188501_() < 0.5) {
                level.m_7731_(pos, (BlockState)((Block)CosmoBlocks.SAPPY_BIRCH_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))), 11);
                level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223717_((Entity)player));
                inHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
        if (!level.f_46443_ && inHand.m_41720_() instanceof HoeItem && block == Blocks.f_152549_) {
            for (int i = 0; i < 4; ++i) {
                if (!((double)level.m_213780_().m_188501_() < 0.25)) continue;
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)CosmoItems.TUBER.get()));
            }
        }
        if (!level.f_46443_ && (item = inHand.m_41720_()) instanceof PottedCropItem) {
            PottedCropItem seed = (PottedCropItem)item;
            if (block == Blocks.f_50276_) {
                player.m_6674_(hand);
                seed.plantCrop(level, pos, player, inHand);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
        if (block.m_49965_().m_61092_().stream().anyMatch(prop -> prop.m_61708_().equals("bites"))) {
            if (CosmoCompat.fd && player.m_21120_(hand).m_204117_(CosmoItemTags.KNIVES)) {
                return;
            }
            if (((Boolean)CosmoConfig.Common.APPLE_FLAVOR.get()).booleanValue() && state.m_204336_(CosmoBlockTags.EXUBERANT_SOURCES)) {
                player.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.EXUBERANT.get(), 2100));
            }
            if (((Boolean)CosmoConfig.Common.GLOW_BERRY_FLAVOR.get()).booleanValue() && state.m_204336_(CosmoBlockTags.TRACER_SOURCES)) {
                player.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.TRACER.get(), 300));
            }
        }
        if (!CosmoCompat.bg || !((Boolean)CosmoConfig.Common.BERRY_GOOD_COMPAT_TWEAKS.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Map<String, List<Item>> compatMap = Map.of("ars_nouveau", List.of(CosmoCompat.SOURCEBERRY), "habitat", List.of(CosmoCompat.KABLOOM), "undergarden", List.of(CosmoCompat.BLISTERBERRY, CosmoCompat.UNDERBEANS, CosmoCompat.DROOPFRUIT));
        for (Map.Entry<String, List<Item>> entry : compatMap.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            for (Item berry : entry.getValue()) {
                if (!stack.m_150930_(berry)) continue;
                event.setUseItem(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType().equals((Object)VillagerProfession.f_35590_)) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)1, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)CosmoItems.WILDBERRY.get(), 32, 1, 16, 2), new TradeUtil.BlueprintTrade((Item)CosmoItems.FIDDLEHEAD.get(), 32, 1, 16, 2)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)CosmoItems.WHEATGRASS.get(), 24, 1, 12, 5)});
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        if (!CosmoCompat.fd) {
            TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, (Item)CosmoItems.LLAMA_MARSHMALLOW.get(), 1, 16, 2)});
            TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(3, (Item)CosmoItems.LLAMA_MARSHMALLOW.get(), 2, 8, 3)});
            TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, (Item)CosmoItems.LLAMA_MARSHMALLOW_BROWN.get(), 1, 16, 2)});
            TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(3, (Item)CosmoItems.LLAMA_MARSHMALLOW_BROWN.get(), 2, 8, 3)});
        }
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, (Item)CosmoItems.WANDERING_GELATO.get(), 1, 16, 2)});
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(3, (Item)CosmoItems.WANDERING_GELATO.get(), 2, 8, 3)});
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, (Item)CosmoItems.LLAMA_MARSHMALLOW_TRADER.get(), 1, 16, 2)});
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(3, (Item)CosmoItems.LLAMA_MARSHMALLOW_TRADER.get(), 2, 8, 3)});
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(6, (Item)CosmoItems.TRAVELERS_PANINI.get(), 1, 8, 2)});
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(9, (Item)CosmoItems.TRAVELERS_PANINI.get(), 2, 4, 3)});
        if (CosmoCompat.an && ((Boolean)CosmoConfig.Common.BERRY_GOOD_COMPAT_TWEAKS.get()).booleanValue()) {
            TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)CosmoItems.SOURCE_BERRY_PIPS.get(), 1, 12, 1)});
        }
        if (CosmoCompat.ha && ((Boolean)CosmoConfig.Common.BERRY_GOOD_COMPAT_TWEAKS.get()).booleanValue()) {
            TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)CosmoItems.KABLOOM_PIPS.get(), 1, 12, 1)});
        }
        if (((Boolean)CosmoConfig.Common.COSMOPOLITAN_COCKTAIL.get()).booleanValue()) {
            TradeUtil.addRareWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(64, (Item)CosmoItems.COSMOPOLITAN_COCKTAIL.get(), 1, 1, 5)});
        }
    }

    public static void condensedMilkEffect(Level level, LivingEntity living, ItemStack stack) {
        Object effect;
        Iterator itr = living.m_21220_().iterator();
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        while (itr.hasNext()) {
            effect = (MobEffectInstance)itr.next();
            if (effect.m_19564_() >= 1 || !effect.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_))) continue;
            effects.add(effect.m_19544_());
        }
        if (!effects.isEmpty()) {
            if (stack.m_150930_((Item)CosmoItems.CONDENSED_MILK_BUCKET.get())) {
                for (MobEffect effect2 : effects) {
                    MobEffectInstance instance = living.m_21124_(effect2);
                    if (instance == null || MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(living, instance))) continue;
                    living.m_21195_(effect2);
                }
            } else {
                effect = (MobEffect)effects.get(level.f_46441_.m_188503_(effects.size()));
                MobEffectInstance instance = living.m_21124_((MobEffect)effect);
                if (instance != null && !MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(living, instance))) {
                    living.m_21195_((MobEffect)effect);
                }
            }
        }
    }

    public static void creamEffect(Level level, LivingEntity living, ItemStack stack) {
        RandomSource random = level.m_213780_();
        List<MobEffectInstance> effects = living.m_21220_().stream().filter(inst -> inst.m_19557_() != -1).map(MobEffectInstance::new).toList();
        if (effects.isEmpty()) {
            return;
        }
        if (stack.m_150930_((Item)CosmoItems.CREAM.get())) {
            MobEffectInstance pick = effects.get(random.m_188503_(effects.size()));
            CosmoEvents.applyAdjustment(living, pick, random);
        } else {
            for (MobEffectInstance inst2 : effects) {
                CosmoEvents.applyAdjustment(living, inst2, random);
            }
        }
    }

    private static void applyAdjustment(LivingEntity living, MobEffectInstance instance, RandomSource random) {
        int i = random.m_188503_(401) - 200;
        int newDuration = instance.m_19557_() + i;
        living.m_21195_(instance.m_19544_());
        if (newDuration > 0) {
            MobEffectInstance newInstance = new MobEffectInstance(instance.m_19544_(), newDuration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_());
            living.m_7292_(newInstance);
        }
    }
}

