/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.misc;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.core.misc.CaroteneCapability;
import com.gumillea.cosmopolitan.core.reg.CosmoEffects;
import com.gumillea.cosmopolitan.core.reg.CosmoItems;
import com.gumillea.cosmopolitan.core.util.CosmoBlockTags;
import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmopolitan")
public class CaroteneTickHandler {
    private static int tick = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)CosmoConfig.Common.CARROT_FLAVOR.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (++tick < 400) {
            return;
        }
        tick = 0;
        ServerPlayer player = (ServerPlayer)event.player;
        player.getCapability(CaroteneCapability.CAP).ifPresent(cap -> {
            boolean hasEffect = player.m_21023_((MobEffect)CosmoEffects.CAROTENE.get());
            int decay = hasEffect ? 40 : 10;
            cap.add(-decay);
            CaroteneTickHandler.updateCaroteneEffect(player, cap.get());
        });
    }

    @SubscribeEvent
    public static void onItemUsed(LivingEntityUseItemEvent.Finish event) {
        if (!((Boolean)CosmoConfig.Common.CARROT_FLAVOR.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItem();
        LivingEntity user = event.getEntity();
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            if (stack.m_41614_() && stack.m_204117_(CosmoItemTags.CAROTENE_SOURCES)) {
                int nutrition = Objects.requireNonNull(stack.getFoodProperties((LivingEntity)player)).m_38744_();
                player.getCapability(CaroteneCapability.CAP).ifPresent(cap -> {
                    int i = stack.m_204117_(CosmoItemTags.ICE_CREAM) || stack.m_150930_((Item)CosmoItems.CARROT_MILKSHAKE.get()) ? nutrition * 3 : nutrition;
                    cap.add(i * 30);
                    CaroteneTickHandler.updateCaroteneEffect(player, cap.get());
                });
            }
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        BlockState state = level.m_8055_(event.getPos());
        Block block = state.m_60734_();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (block.m_49965_().m_61092_().stream().anyMatch(prop -> prop.m_61708_().equals("bites"))) {
                if (CosmoCompat.fd && player2.m_21120_(hand).m_204117_(CosmoItemTags.KNIVES)) {
                    return;
                }
                if (((Boolean)CosmoConfig.Common.CARROT_FLAVOR.get()).booleanValue() && state.m_204336_(CosmoBlockTags.CAROTENE_SOURCES)) {
                    player2.getCapability(CaroteneCapability.CAP).ifPresent(cap -> {
                        cap.add(60);
                        CaroteneTickHandler.updateCaroteneEffect(player2, cap.get());
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!((Boolean)CosmoConfig.Common.CARROT_FLAVOR.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        player.getCapability(CaroteneCapability.CAP).ifPresent(cap -> cap.set(0));
    }

    private static void updateCaroteneEffect(ServerPlayer player, int i) {
        boolean hasEffect = player.m_21023_((MobEffect)CosmoEffects.CAROTENE.get());
        if (i >= 800 && !hasEffect) {
            player.m_7292_(new MobEffectInstance((MobEffect)CosmoEffects.CAROTENE.get(), -1));
        }
        if (i <= 500 && hasEffect) {
            player.m_21195_((MobEffect)CosmoEffects.CAROTENE.get());
        }
    }
}

