/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.blockEntity;

import com.gumillea.cosmopolitan.common.block.FrozenDessertTubBlock;
import com.gumillea.cosmopolitan.core.reg.CosmoBlockEntityTypes;
import com.gumillea.cosmopolitan.core.reg.CosmoFluids;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FrozenDessertTubBlockEntity
extends BlockEntity {
    public static final int capacity = 3000;
    private int remainingTime = 0;
    private boolean isProcessing = false;
    private final FluidTank tank = new FluidTank(3000){

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            BlockState state = FrozenDessertTubBlockEntity.this.f_58857_.m_8055_(FrozenDessertTubBlockEntity.this.f_58858_);
            if (!((Boolean)state.m_61143_((Property)FrozenDessertTubBlock.OPEN)).booleanValue()) {
                return 0;
            }
            return super.fill(stack, action);
        }

        public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
            BlockState state = FrozenDessertTubBlockEntity.this.f_58857_.m_8055_(FrozenDessertTubBlockEntity.this.f_58858_);
            if (!((Boolean)state.m_61143_((Property)FrozenDessertTubBlock.OPEN)).booleanValue()) {
                return FluidStack.EMPTY;
            }
            return super.drain(stack, action);
        }

        protected void onContentsChanged() {
            FrozenDessertTubBlockEntity.this.m_6596_();
            if (FrozenDessertTubBlockEntity.this.f_58857_ != null && !((FrozenDessertTubBlockEntity)FrozenDessertTubBlockEntity.this).f_58857_.f_46443_) {
                FrozenDessertTubBlockEntity.this.f_58857_.m_7260_(FrozenDessertTubBlockEntity.this.f_58858_, FrozenDessertTubBlockEntity.this.m_58900_(), FrozenDessertTubBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public FrozenDessertTubBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CosmoBlockEntityTypes.FROZEN_DESSERT_TUB.get(), pos, state);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        BooleanProperty OPEN = FrozenDessertTubBlock.OPEN;
        boolean isOpen = (Boolean)state.m_61143_((Property)OPEN);
        if (blockEntity instanceof FrozenDessertTubBlockEntity) {
            FrozenDessertTubBlockEntity tub = (FrozenDessertTubBlockEntity)blockEntity;
            if (tub.isProcessing) {
                if (isOpen) {
                    tub.isProcessing = false;
                    tub.remainingTime = 0;
                } else if (--tub.remainingTime <= 0) {
                    FrozenDessertTubBlockEntity.completeProcessing(level, pos, tub);
                }
                level.m_7260_(pos, state, state, 3);
            } else if (!isOpen && FrozenDessertTubBlockEntity.isValidFluid(tub)) {
                FrozenDessertTubBlockEntity.startProcessing(tub);
            }
        }
    }

    private static boolean isValidFluid(FrozenDessertTubBlockEntity tub) {
        FluidStack stack = tub.getTank().getFluid();
        return !stack.isEmpty() && stack.getFluid().m_6212_((Fluid)CosmoFluids.CONDENSED_MILK.get());
    }

    private static void startProcessing(FrozenDessertTubBlockEntity tub) {
        tub.isProcessing = true;
        tub.remainingTime = 6000;
    }

    private static void completeProcessing(Level level, BlockPos pos, FrozenDessertTubBlockEntity tub) {
        FluidStack stack = tub.getTank().getFluid();
        if (stack.getFluid() != CosmoFluids.CONDENSED_MILK.get()) {
            return;
        }
        tub.getTank().setFluid(new FluidStack((Fluid)CosmoFluids.CREAM.get(), stack.getAmount()));
        tub.isProcessing = false;
        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
        FrozenDessertTubBlock.contentApply(level, pos);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag.m_128469_("Tank"));
        this.remainingTime = tag.m_128451_("RemainingTime");
        this.isProcessing = tag.m_128471_("IsProcessing");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128405_("RemainingTime", this.remainingTime);
        tag.m_128379_("IsProcessing", this.isProcessing);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("Tank")) {
            this.tank.readFromNBT(tag.m_128469_("Tank"));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }
}

