/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.block;

import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.RegistryObject;

public class PottedCropBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final int MAX_AGE = 1;
    public static final BooleanProperty PRUNED = BooleanProperty.m_61465_((String)"pruned");
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)1);
    private final RegistryObject<Item> crop;

    public PottedCropBlock(BlockBehaviour.Properties properties, RegistryObject<Item> crop) {
        super(properties);
        this.crop = crop;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)PRUNED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState p_53556_, BlockGetter p_53557_, BlockPos p_53558_, CollisionContext p_53559_) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState p_53554_) {
        return RenderShape.MODEL;
    }

    public ItemStack getCropItem() {
        return new ItemStack((ItemLike)this.crop.get());
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return this.getCropItem();
    }

    private boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) == 1;
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (!((Boolean)state.m_61143_((Property)PRUNED)).booleanValue() && !this.isMaxAge(state) && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (source.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void pruneCrop(BlockState state, Level level, BlockPos pos, Player player) {
        boolean pruned = (Boolean)state.m_61143_((Property)PRUNED);
        RandomSource rand = level.m_213780_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double d0 = (rand.m_188500_() - 0.5) * 0.02;
                double d1 = 0.075;
                double d2 = (rand.m_188500_() - 0.5) * 0.02;
                double x = (double)pos.m_123341_() + 0.3 + rand.m_188500_() * 0.4;
                double y = pos.m_123342_() + 1;
                double z = (double)pos.m_123343_() + 0.3 + rand.m_188500_() * 0.4;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152470_.m_49966_()), x, y, z, 0, d0, d1, d2, 0.5);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 0.8f, 0.8f);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRUNED, (Comparable)Boolean.valueOf(!pruned)), 3);
        level.m_142346_((Entity)player, !pruned ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean flag = this.isMaxAge(state);
        boolean pruned = (Boolean)state.m_61143_((Property)PRUNED);
        ItemStack inHand = player.m_21120_(hand);
        if (!inHand.m_41619_() && inHand.m_150930_(Items.f_42574_)) {
            if (!level.f_46443_) {
                this.pruneCrop(state, level, pos, player);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (pruned) {
            return InteractionResult.PASS;
        }
        if (flag) {
            int amount = ((Item)this.crop.get()).m_7968_().m_204117_(CosmoItemTags.BERRIES) ? 1 + level.f_46441_.m_188503_(2) : 1;
            PottedCropBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.crop.get(), amount));
            level.m_5594_(null, pos, SoundEvents.f_144088_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        ItemStack crop = new ItemStack((ItemLike)this.crop.get());
        if (!player.m_36356_(crop)) {
            player.m_36176_(crop, false);
        }
        level.m_7731_(pos, Blocks.f_50276_.m_49966_(), 3);
        level.m_5594_(null, pos, SoundEvents.f_144068_, SoundSource.BLOCKS, 0.8f, 0.8f);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)Blocks.f_50276_.m_49966_()));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
        builder.m_61104_(new Property[]{PRUNED});
    }

    public boolean m_7370_(LevelReader reader, BlockPos pos, BlockState state, boolean b) {
        return (Boolean)state.m_61143_((Property)PRUNED) == false && (Integer)state.m_61143_((Property)AGE) < 1;
    }

    public boolean m_214167_(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 2);
    }

    protected boolean m_6266_(BlockState p_51042_, BlockGetter p_51043_, BlockPos p_51044_) {
        return true;
    }

    public boolean m_7898_(BlockState p_51028_, LevelReader p_51029_, BlockPos p_51030_) {
        return true;
    }
}

