/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.block;

import com.gumillea.cosmopolitan.common.blockEntity.FrozenDessertTubBlockEntity;
import com.gumillea.cosmopolitan.common.fluid.CosmoIceCreamFluidType;
import com.gumillea.cosmopolitan.core.misc.recipes.TubExtractRecipe;
import com.gumillea.cosmopolitan.core.misc.recipes.TubInjectRecipe;
import com.gumillea.cosmopolitan.core.misc.recipes.TubInteractingRecipe;
import com.gumillea.cosmopolitan.core.reg.CosmoBlockEntityTypes;
import com.gumillea.cosmopolitan.core.reg.CosmoFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;

public class FrozenDessertTubBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape INSIDE = Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)INSIDE, (BooleanOp)BooleanOp.f_82685_);

    public FrozenDessertTubBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean player = context.m_43723_() != null && context.m_43723_().m_6144_();
        return player ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)context.m_8125_()) : (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83144_();
        }
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FrozenDessertTubBlockEntity)) {
            return InteractionResult.PASS;
        }
        FrozenDessertTubBlockEntity tub = (FrozenDessertTubBlockEntity)blockEntity;
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        ItemStack inHand = player.m_21120_(hand);
        if (player.m_6144_() || !inHand.m_41619_() && inHand.m_204117_(ItemTags.f_271360_)) {
            if (!level.f_46443_) {
                FrozenDessertTubBlock.setOpen(state, level, pos, player);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!open) {
            return InteractionResult.PASS;
        }
        ItemStack result = TubInjectRecipe.tryApply(level, tub, inHand, player, hand);
        if (!result.m_41619_()) {
            FrozenDessertTubBlock.contentApply(level, pos);
            return InteractionResult.SUCCESS;
        }
        result = TubExtractRecipe.tryApply(level, tub, inHand, player, hand);
        if (!result.m_41619_()) {
            FluidStack stack = tub.getTank().getFluid();
            if (stack.getFluid().getFluidType() instanceof CosmoIceCreamFluidType || stack.getFluid().m_6212_((Fluid)CosmoFluids.CREAM.get())) {
                level.m_5594_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 0.8f, 0.8f);
            } else {
                level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.8f, 0.8f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void setOpen(BlockState state, Level level, BlockPos pos, Player player) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        level.m_5594_(null, pos, SoundEvents.f_12056_, SoundSource.BLOCKS, 0.8f, 0.8f);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)), 3);
        level.m_142346_((Entity)player, !open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FrozenDessertTubBlockEntity(pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        FrozenDessertTubBlockEntity tub;
        FluidStack stack;
        BlockEntity entity = getter.m_7702_(pos);
        if (entity instanceof FrozenDessertTubBlockEntity && !(stack = (tub = (FrozenDessertTubBlockEntity)entity).getTank().getFluid()).isEmpty() && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return stack.getFluid().getFluidType().getLightLevel(stack);
        }
        return super.getLightEmission(state, getter, pos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (level.f_46443_ || !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FrozenDessertTubBlockEntity)) {
            return;
        }
        FrozenDessertTubBlockEntity tub = (FrozenDessertTubBlockEntity)blockEntity;
        FluidStack fluidStack = tub.getTank().getFluid();
        if (entity instanceof ItemEntity) {
            TubInteractingRecipe.tryApply(level, tub, pos, state);
        }
        if (fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_)) {
            entity.m_20093_();
        } else {
            if (entity.m_6060_()) {
                entity.m_20095_();
            }
            if (fluidStack.getFluid().getFluidType() instanceof CosmoIceCreamFluidType) {
                entity.m_146924_(true);
            }
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : FrozenDessertTubBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)CosmoBlockEntityTypes.FROZEN_DESSERT_TUB.get()), FrozenDessertTubBlockEntity::tick);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static void contentApply(Level level, BlockPos pos) {
        RandomSource rand = level.m_213780_();
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof FrozenDessertTubBlockEntity) {
            FrozenDessertTubBlockEntity tub = (FrozenDessertTubBlockEntity)entity;
            FluidStack stack = tub.getTank().getFluid();
            if (stack.getFluid().m_6212_((Fluid)Fluids.f_76195_)) {
                level.m_5594_(null, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 0.8f, 0.8f);
            } else if (stack.getFluid().m_6212_((Fluid)CosmoFluids.CREAM.get()) || stack.getFluid().getFluidType() instanceof CosmoIceCreamFluidType) {
                level.m_5594_(null, pos, SoundEvents.f_12482_, SoundSource.BLOCKS, 0.8f, 0.8f);
            } else {
                level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.8f, 0.8f);
            }
        }
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (int i = 0; i < 6; ++i) {
                double d0 = (rand.m_188500_() - 0.5) * 0.02;
                double d1 = 0.075;
                double d2 = (rand.m_188500_() - 0.5) * 0.02;
                double x = (double)pos.m_123341_() + 0.3 + rand.m_188500_() * 0.4;
                double y = pos.m_123342_() + 1;
                double z = (double)pos.m_123343_() + 0.3 + rand.m_188500_() * 0.4;
                server.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 0, d0, d1, d2, 0.5);
            }
        }
    }
}

