/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network.spell;

import io.redspace.ironsspellbooks.player.ClientSpellCastHelper;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientboundParticleShockwave {
    Vec3 pos;
    float radius;
    String particleName;

    public ClientboundParticleShockwave(Vec3 pos, float radius, ParticleType particleType) {
        this.pos = pos;
        this.radius = radius;
        this.particleName = Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getKey((Object)particleType)).toString();
    }

    public ClientboundParticleShockwave(FriendlyByteBuf buf) {
        this.pos = this.readVec3(buf);
        this.radius = buf.readFloat();
        this.particleName = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.writeVec3(this.pos, buf);
        buf.writeFloat(this.radius);
        buf.m_130070_(this.particleName);
    }

    public Vec3 readVec3(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    public void writeVec3(Vec3 vec3, FriendlyByteBuf buf) {
        buf.writeDouble(vec3.f_82479_);
        buf.writeDouble(vec3.f_82480_);
        buf.writeDouble(vec3.f_82481_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            try {
                ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ResourceLocation.parse((String)this.particleName));
                ClientSpellCastHelper.handleClientboundShockwaveParticle(this.pos, this.radius, type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return true;
    }
}

