/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.spell.school;

import com.squoshi.irons_spells_js.IronsSpellsJSPlugin;
import com.squoshi.irons_spells_js.util.ISSKJSUtils;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class SchoolTypeJSBuilder
extends BuilderBase<SchoolType> {
    public transient ResourceLocation schoolResource;
    public transient TagKey<Item> focus;
    public transient Component name;
    public transient LazyOptional<Attribute> powerAttribute;
    public transient LazyOptional<Attribute> resistanceAttribute;
    public transient LazyOptional<SoundEvent> defaultCastSound;
    public transient ResourceKey<DamageType> damageType;

    public SchoolTypeJSBuilder(ResourceLocation i) {
        super(i);
        this.schoolResource = i;
    }

    @Info(value="        Sets the ID of the item tag used for the focus item.\n        Focus items need the `\"irons_spellbooks:school_focus\"` tag, as well as the tag specified here.\n")
    public SchoolTypeJSBuilder setFocus(ResourceLocation focus) {
        this.focus = ItemTags.create((ResourceLocation)focus);
        return this;
    }

    @Info(value="        Sets the name of the school. It requires a `Component`, which allows custom colors and formatting. You can also use `Text`.\n")
    public SchoolTypeJSBuilder setName(Component name) {
        this.name = name;
        return this;
    }

    @Info(value="        Sets the power attribute of the school. It takes either a String, ResourceLocation, or just an Attribute.\n")
    public SchoolTypeJSBuilder setPowerAttribute(ISSKJSUtils.AttributeHolder powerAttribute) {
        this.powerAttribute = LazyOptional.of(() -> Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(powerAttribute.getLocation())));
        return this;
    }

    @Info(value="        Sets the resistance attribute of the school. It takes either a String, ResourceLocation, or just an Attribute.\n")
    public SchoolTypeJSBuilder setResistanceAttribute(ISSKJSUtils.AttributeHolder resistanceAttribute) {
        this.resistanceAttribute = LazyOptional.of(() -> Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(resistanceAttribute.getLocation())));
        return this;
    }

    @Info(value="        Sets the default cast sound of the school. It takes either a String, ResourceLocation, or just a SoundEvent.\n")
    public SchoolTypeJSBuilder setDefaultCastSound(ISSKJSUtils.SoundEventHolder defaultCastSound) {
        this.defaultCastSound = LazyOptional.of(() -> Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(defaultCastSound.getLocation())));
        return this;
    }

    @Info(value="        Sets the damage type of the school. It takes either a String, ResourceLocation, or just a DamageType.\n        Damage types can be created using datapacks or server scripts, or you can use an existing damage type.\n")
    public SchoolTypeJSBuilder setDamageType(ISSKJSUtils.DamageTypeHolder damageType) {
        this.damageType = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)damageType.getLocation());
        return this;
    }

    public RegistryInfo<SchoolType> getRegistryType() {
        return IronsSpellsJSPlugin.SCHOOL_REGISTRY;
    }

    public SchoolType createObject() {
        return new SchoolType(this.schoolResource, this.focus, this.name, this.powerAttribute, this.resistanceAttribute, this.defaultCastSound, this.damageType);
    }
}

