/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.spell;

import com.squoshi.irons_spells_js.util.ISSKJSUtils;
import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import net.minecraft.resources.ResourceLocation;

public interface AbstractSpellWrapper {
    @Info(value="    Returns a spell registry object by its ResourceLocation.\n")
    public static AbstractSpell of(ISSKJSUtils.SpellHolder spellHolder) {
        return SpellRegistry.getSpell((ResourceLocation)spellHolder.getLocation());
    }

    @Info(value="    Returns whether a spell is registered or not.\n")
    public static boolean exists(ISSKJSUtils.SpellHolder spellHolder) {
        return SpellRegistry.getSpell((ResourceLocation)spellHolder.getLocation()) != null;
    }

    @Info(value="    Returns whether an object is a spell or not.\n")
    public static boolean isSpell(Object o) {
        return o instanceof AbstractSpell;
    }

    @Info(value="    Returns either `ENABLED`, `DISABLED`, or `UNREGISTERED`, based on the spell inputted.\n")
    public static SpellStatus checkStatus(ISSKJSUtils.SpellHolder spellHolder) {
        SpellStatus enabled = SpellRegistry.getSpell((ResourceLocation)spellHolder.getLocation()).isEnabled() ? SpellStatus.ENABLED : SpellStatus.DISABLED;
        return AbstractSpellWrapper.exists(spellHolder) ? enabled : SpellStatus.UNREGISTERED;
    }

    @Info(value="    Returns whether a spell is enabled in the config or not.\n")
    public static boolean isEnabled(ISSKJSUtils.SpellHolder spellHolder) {
        return SpellRegistry.getSpell((ResourceLocation)spellHolder.getLocation()).isEnabled();
    }

    public static enum SpellStatus {
        REGISTERED,
        UNREGISTERED,
        ENABLED,
        DISABLED;

    }
}

