/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.item;

import com.squoshi.irons_spells_js.util.ISSKJSUtils;
import dev.latvian.mods.kubejs.item.custom.HandheldItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Tier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MagicSwordItemBuilderJS
extends HandheldItemBuilder {
    public transient List<AttributeHolder> additionalAttributes = new ArrayList<AttributeHolder>();
    public transient List<SpellHolder> spellHolders = new ArrayList<SpellHolder>();

    public MagicSwordItemBuilderJS(ResourceLocation i) {
        super(i, 3.0f, -2.4f);
    }

    @Info(value="        Adds a spell to the default spell list of the item. It takes a spell ID (or just a spell object), and the spell level as an integer.\n")
    public MagicSwordItemBuilderJS addDefaultSpell(ISSKJSUtils.SpellHolder spell, int spellLevel) {
        this.spellHolders.add(new SpellHolder(spell.getLocation(), spellLevel));
        return this;
    }

    @Info(value="        Adds an additional attribute to the item. It takes an attribute ID (or just an attribute object), the modifier name, the modifier amount, and the modifier operation.\n        The modifier operation can be either `ADDITION`, `MULTIPLY_TOTAL` or `MULTIPLY_BASE`.\n")
    public MagicSwordItemBuilderJS addAdditionalAttribute(ISSKJSUtils.AttributeHolder attribute, String modifierName, double modifierAmount, AttributeModifier.Operation modifierOperation) {
        this.additionalAttributes.add(new AttributeHolder(attribute.getLocation(), new AttributeModifier(modifierName, modifierAmount, modifierOperation)));
        return this;
    }

    public MagicSwordItem createObject() {
        HashMap<Attribute, AttributeModifier> map = new HashMap<Attribute, AttributeModifier>(Map.of());
        for (AttributeHolder holder : this.additionalAttributes) {
            Attribute attribute = Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(holder.attribute()));
            map.put(attribute, holder.modifier());
        }
        SpellDataRegistryHolder[] spellDataHolders = new SpellDataRegistryHolder[this.spellHolders.size()];
        Iterator<SpellHolder> iterator = this.spellHolders.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            SpellHolder spells = iterator.next();
            spellDataHolders[i] = new SpellDataRegistryHolder(RegistryObject.create((ResourceLocation)spells.spell, (IForgeRegistry)((IForgeRegistry)SpellRegistry.REGISTRY.get())), spells.spellLevel);
            ++i;
        }
        return new MagicSwordItem((Tier)this.toolTier, (double)this.attackDamageBaseline, (double)this.speedBaseline, spellDataHolders, map, this.createItemProperties());
    }

    public record SpellHolder(ResourceLocation spell, int spellLevel) {
    }

    public record AttributeHolder(ResourceLocation attribute, AttributeModifier modifier) {
    }
}

