/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.compat.entityjs.entity;

import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import com.squoshi.irons_spells_js.compat.entityjs.entity.builder.SpellCastingMobJSBuilder;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntityJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.ModKeybinds;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpellCastingMobJS
extends PathfinderMob
implements IAnimatableJS,
IMagicEntity {
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.m_135353_(SpellCastingMobJS.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DRINKING_POTION = SynchedEntityData.m_135353_(SpellCastingMobJS.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final MagicData playerMagicData = new MagicData(true);
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E"), "Drinking speed penalty", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
    @Nullable
    private SpellData castingSpell;
    private final HashMap<String, AbstractSpell> spells = Maps.newHashMap();
    private int drinkTime;
    public boolean hasUsedSingleAttack;
    private AbstractSpell lastCastSpellType = SpellRegistry.none();
    private AbstractSpell instantCastSpellType = SpellRegistry.none();
    private final SpellCastingMobJSBuilder builder;
    private final AnimatableInstanceCache animationFactory;
    protected PathNavigation navigation;
    public final PartEntityJS<?>[] partEntities;
    private final NonNullList<ItemStack> handItems;
    private final NonNullList<ItemStack> armorItems;
    protected boolean thisJumping;

    public String entityName() {
        return this.m_6095_().toString();
    }

    public SpellCastingMobJS(SpellCastingMobJSBuilder builder, EntityType<SpellCastingMobJS> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
        this.f_21365_ = this.createLookControl();
        this.handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        this.armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        this.thisJumping = false;
        this.builder = builder;
        this.animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        ArrayList<PartEntityJS> tempPartEntities = new ArrayList<PartEntityJS>();
        for (ContextUtils.PartEntityParams params : builder.partEntityParamsList) {
            PartEntityJS partEntity = new PartEntityJS((LivingEntity)this, params.name, params.width, params.height, params.builder);
            tempPartEntities.add(partEntity);
        }
        this.partEntities = tempPartEntities.toArray(new PartEntityJS[0]);
        this.navigation = this.m_6037_(pLevel);
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected boolean m_8106_() {
                return SpellCastingMobJS.this.m_5448_() == null;
            }
        };
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CANCEL_CAST, (Object)false);
        this.f_19804_.m_135372_(DATA_DRINKING_POTION, (Object)false);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DRINKING_POTION);
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean bool) {
        this.hasUsedSingleAttack = bool;
    }

    protected void setDrinkingPotion(boolean drinkingPotion) {
        this.f_19804_.m_135381_(DATA_DRINKING_POTION, (Object)drinkingPotion);
    }

    public void startDrinkingPotion() {
        if (!this.m_9236_().f_46443_) {
            this.setDrinkingPotion(true);
            this.drinkTime = 35;
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
            attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
        }
    }

    private void finishDrinkingPotion() {
        this.setDrinkingPotion(false);
        this.m_5634_(Math.min(Math.max(10.0f, this.m_21233_() / 10.0f), this.m_21233_() / 4.0f));
        this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (this.m_9236_().f_46443_ && pKey.m_135015_() == DATA_CANCEL_CAST.m_135015_()) {
            this.cancelCast();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound);
        pCompound.m_128379_("usedSpecial", this.hasUsedSingleAttack);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound);
        if (syncedSpellData.isCasting()) {
            AbstractSpell spell = SpellRegistry.getSpell((String)syncedSpellData.getCastingSpellId());
            this.initiateCastSpell(spell, syncedSpellData.getCastingSpellLevel());
        }
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.m_128471_("usedSpecial");
    }

    public void cancelCast() {
        if (this.builder.onCancelledCast != null) {
            this.builder.onCancelledCast.accept(this);
        }
        if (this.isCasting()) {
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_CANCEL_CAST, (Object)((Boolean)this.f_19804_.m_135370_(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.m_9236_().f_46443_) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void startAutoSpinAttack(int pAttackTicks) {
        this.f_20938_ = pAttackTicks;
        if (!this.m_9236_().f_46443_) {
            this.m_21155_(4, true);
        }
        this.m_146922_((float)(Math.atan2(this.m_20184_().f_82479_, this.m_20184_().f_82481_) * 57.2957763671875));
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (this.m_9236_().f_46443_) {
            boolean isCasting = this.playerMagicData.isCasting();
            this.playerMagicData.setSyncedData(syncedSpellData);
            this.castingSpell = this.playerMagicData.getCastingSpell();
            if (this.castingSpell != null) {
                if (!this.playerMagicData.isCasting() && isCasting) {
                    this.castComplete();
                } else if (this.playerMagicData.isCasting() && !isCasting) {
                    AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
                    this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
                    if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                        this.instantCastSpellType = this.castingSpell.getSpell();
                        this.castingSpell.getSpell().onClientPreCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                        this.castComplete();
                    }
                }
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isDrinkingPotion()) {
            if (this.drinkTime-- <= 0) {
                this.finishDrinkingPotion();
            } else if (this.drinkTime % 4 == 0 && !this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11911_, this.m_5720_(), 1.0f, Utils.random.m_188501_() * 0.1f + 0.9f);
            }
        }
        if (this.castingSpell != null) {
            this.playerMagicData.handleCastDuration();
            if (this.playerMagicData.isCasting()) {
                this.castingSpell.getSpell().onServerCastTick(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
            }
            this.forceLookAtTarget(this.m_5448_());
            if (this.playerMagicData.getCastDurationRemaining() <= 0) {
                if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                    this.castingSpell.getSpell().onCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
                }
                this.castComplete();
            } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
                this.castingSpell.getSpell().onCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
            }
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
        } else {
            this.castingSpell = new SpellData(spell, spellLevel);
            if (this.m_5448_() != null) {
                this.forceLookAtTarget(this.m_5448_());
            }
            if (!this.m_9236_().f_46443_ && !this.castingSpell.getSpell().checkPreCastConditions(this.m_9236_(), spellLevel, (LivingEntity)this, this.playerMagicData)) {
                this.castingSpell = null;
            } else {
                if (spell != SpellRegistry.TELEPORT_SPELL.get() && spell != SpellRegistry.FROST_STEP_SPELL.get()) {
                    if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
                        this.setTeleportLocationBehindTarget(3);
                    } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
                        this.setBurningDashDirectionData();
                    }
                } else {
                    this.setTeleportLocationBehindTarget(10);
                }
                this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this), CastSource.MOB, SpellSelectionManager.MAINHAND);
                if (!this.m_9236_().f_46443_) {
                    this.castingSpell.getSpell().onServerPreCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
                }
            }
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        if (this.builder.isCasting != null) {
            Object obj = this.builder.isCasting.apply(this);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[KubeJS Irons Spells]: Invalid return value for isCasting from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + this.playerMagicData.isCasting()));
        }
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.m_5448_();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.m_20154_().m_82541_().m_82490_((double)(-distance));
            Vec3 pos = target.m_20182_();
            Vec3 teleportPos = rotation.m_82549_(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).m_82542_(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.m_9236_(), (Vec3)target.m_20182_().m_82546_(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180))).m_82549_(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.f_82479_, teleportPos.f_82480_ + (double)0.1f, teleportPos.f_82481_);
                AABB reposBB = this.m_20191_().m_82383_(teleportPos.m_82546_(this.m_20182_()));
                if (this.m_9236_().m_186437_((Entity)this, reposBB.m_82400_((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.m_20182_()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.m_20182_()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    private void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d1 = target.m_20188_() - this.m_20188_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
            this.m_146926_(f1 % 360.0f);
            this.m_146922_(f % 360.0f);
        }
    }

    private void addClientSideParticles() {
        double d0 = 0.4;
        double d1 = 0.3;
        double d2 = 0.35;
        float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
    }

    public void m_20234_(int entityId) {
        super.m_20234_(entityId);
        for (int i = 0; i < this.partEntities.length; ++i) {
            PartEntityJS<?> partEntity = this.partEntities[i];
            if (partEntity == null) continue;
            partEntity.m_20234_(entityId + i + 1);
        }
    }

    public void tickPart(String partName, double offsetX, double offsetY, double offsetZ) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        for (PartEntityJS<?> partEntity : this.partEntities) {
            if (!partEntity.name.equals(partName)) continue;
            partEntity.movePart(x + offsetX, y + offsetY, z + offsetZ, partEntity.m_146908_(), partEntity.m_146909_());
            return;
        }
        EntityJSHelperClass.logWarningMessageOnce((String)("Part with name " + partName + " not found for entity: " + this.entityName()));
    }

    public boolean isMultipartEntity() {
        return this.partEntities != null;
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
    }

    public PartEntity<?>[] getParts() {
        return Objects.requireNonNullElseGet(this.partEntities, () -> new PartEntity[0]);
    }

    public BaseLivingEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    protected Brain.Provider<?> m_5490_() {
        if (EventHandlers.buildBrainProvider.hasListeners()) {
            BuildBrainProviderEventJS event = new BuildBrainProviderEventJS();
            EventHandlers.buildBrainProvider.post((EventJS)event, (Object)this.getTypeId());
            return event.provide();
        }
        return super.m_5490_();
    }

    protected Brain<SpellCastingMobJS> m_8075_(Dynamic<?> p_21069_) {
        if (EventHandlers.buildBrain.hasListeners()) {
            Brain brain = (Brain)UtilsJS.cast((Object)this.m_5490_().m_22073_(p_21069_));
            EventHandlers.buildBrain.post((EventJS)new BuildBrainEventJS(brain), (Object)this.getTypeId());
            return brain;
        }
        return (Brain)UtilsJS.cast((Object)super.m_8075_(p_21069_));
    }

    protected void m_8099_() {
        if (EventHandlers.addGoalTargets.hasListeners()) {
            EventHandlers.addGoalTargets.post((EventJS)new AddGoalTargetsEventJS((Mob)this, this.f_21346_), (Object)this.getTypeId());
        }
        if (EventHandlers.addGoalSelectors.hasListeners()) {
            EventHandlers.addGoalSelectors.post((EventJS)new AddGoalSelectorsEventJS((Mob)this, this.f_21345_), (Object)this.getTypeId());
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.builder.onInteract != null) {
            ContextUtils.MobInteractContext context = new ContextUtils.MobInteractContext((LivingEntity)this, pPlayer, pHand);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onInteract, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onInteract."));
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.builder != null && this.builder.onHurtTarget != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHurtTarget, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHurtTarget."));
        }
        return super.m_7327_(pEntity);
    }

    public void onJump() {
        if (this.builder.onLivingJump != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLivingJump, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingJump."));
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.canJump() && this.m_20096_() && this.m_21573_().m_26572_() && this.shouldJump()) {
            this.jump();
        }
        if (this.builder.aiStep != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.aiStep, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: aiStep."));
        }
    }

    protected void m_6153_() {
        if (this.builder.tickDeath != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.tickDeath, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: tickDeath."));
        } else {
            super.m_6153_();
        }
    }

    protected void m_6119_() {
        super.m_6119_();
        if (this.builder.tickLeash != null) {
            Player $$0 = (Player)this.m_21524_();
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext($$0, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.tickLeash, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: tickLeash."));
        }
    }

    public boolean m_6573_(Player pPlayer) {
        if (this.builder.canBeLeashed != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(pPlayer, (LivingEntity)this);
            Object obj = this.builder.canBeLeashed.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canBeLeashed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to false."));
        }
        return false;
    }

    public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity target) {
        super.m_6710_(target);
        if (this.builder.onTargetChanged != null) {
            ContextUtils.TargetChangeContext context = new ContextUtils.TargetChangeContext(target, (Mob)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onTargetChanged, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onTargetChanged."));
        }
    }

    public void m_8035_() {
        super.m_8035_();
        if (this.builder.ate != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.ate, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: ate."));
        }
    }

    protected PathNavigation m_6037_(Level pLevel) {
        if (this.builder != null && this.builder.createNavigation != null) {
            ContextUtils.EntityLevelContext context = new ContextUtils.EntityLevelContext(pLevel, (LivingEntity)this);
            Object obj = this.builder.createNavigation.apply(context);
            if (obj instanceof PathNavigation) {
                PathNavigation p = (PathNavigation)obj;
                return p;
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for createNavigation from entity: " + var10000 + ". Value: " + obj + ". Must be PathNavigation. Defaulting to super method."));
            return super.m_6037_(pLevel);
        }
        return super.m_6037_(pLevel);
    }

    public MobType m_6336_() {
        if (this.builder != null) {
            return this.builder.mobType;
        }
        return super.m_6336_();
    }

    public void performRangedAttack(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public boolean canJump() {
        return Objects.requireNonNullElse(this.builder.canJump, true);
    }

    public void jump() {
        double jumpPower = this.m_6118_() + this.m_285755_();
        Vec3 currentVelocity = this.m_20184_();
        this.m_20334_(currentVelocity.f_82479_, jumpPower, currentVelocity.f_82481_);
        this.f_19812_ = true;
        if (this.m_20142_()) {
            float yawRadians = this.m_146908_() * ((float)Math.PI / 180);
            this.m_20256_(this.m_20184_().m_82520_(-Math.sin(yawRadians) * 0.2, 0.0, Math.cos(yawRadians) * 0.2));
        }
        this.f_19812_ = true;
        this.onJump();
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    public boolean shouldJump() {
        BlockPos forwardPos = this.m_20183_().m_121945_(this.m_6350_());
        return this.m_9236_().m_46575_(forwardPos, (Entity)this) && (double)this.getStepHeight() < this.m_9236_().m_8055_(forwardPos).m_60808_((BlockGetter)this.m_9236_(), forwardPos).m_83297_(Direction.Axis.Y);
    }

    public HumanoidArm m_5737_() {
        return this.builder.mainArm != null ? (HumanoidArm)this.builder.mainArm : super.m_5737_();
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        if (this.builder.walkTargetValue == null) {
            return super.m_5610_(pos, levelReader);
        }
        ContextUtils.EntityBlockPosLevelContext context = new ContextUtils.EntityBlockPosLevelContext(pos, levelReader, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.walkTargetValue.apply(context), (String)"float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for walkTargetValue from entity: " + var10000 + ". Value: " + this.builder.walkTargetValue.apply(context) + ". Must be a float. Defaulting to " + super.m_5610_(pos, levelReader)));
        return super.m_5610_(pos, levelReader);
    }

    protected boolean m_213814_() {
        if (this.builder.shouldStayCloseToLeashHolder == null) {
            return super.m_213814_();
        }
        Object value = this.builder.shouldStayCloseToLeashHolder.apply(this);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldStayCloseToLeashHolder from entity: " + this.entityName() + ". Value: " + value + ". Must be a boolean. Defaulting to " + super.m_213814_()));
        return super.m_213814_();
    }

    public boolean canFireProjectileWeaponPredicate(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeaponPredicate != null) {
            ContextUtils.EntityProjectileWeaponContext context = new ContextUtils.EntityProjectileWeaponContext(projectileWeapon, (LivingEntity)this);
            Object obj = this.builder.canFireProjectileWeaponPredicate.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canFireProjectileWeaponPredicate from entity: " + var10000 + ". Value: " + obj + ". Must be a boolean. Defaulting to false."));
        }
        return false;
    }

    public boolean canFireProjectileWeapons(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeapon == null) {
            return super.m_5886_(projectileWeapon);
        }
        return this.builder.canFireProjectileWeapon.test(projectileWeapon.m_7968_()) && projectileWeapon instanceof ProjectileWeaponItem;
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeapon) {
        if (!this.canFireProjectileWeapons(projectileWeapon) && !this.canFireProjectileWeaponPredicate(projectileWeapon)) {
            return super.m_5886_(projectileWeapon);
        }
        return this.canFireProjectileWeapons(projectileWeapon) && this.canFireProjectileWeaponPredicate(projectileWeapon);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return this.builder.setAmbientSound != null ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setAmbientSound) : super.m_7515_();
    }

    public boolean m_7252_(ItemStack stack) {
        if (this.builder.canHoldItem != null) {
            ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(stack, (LivingEntity)this);
            Object obj = this.builder.canHoldItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canHoldItem from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7252_(stack)));
        }
        return super.m_7252_(stack);
    }

    protected boolean m_8028_() {
        return Objects.requireNonNullElseGet(this.builder.shouldDespawnInPeaceful, () -> super.m_8028_());
    }

    public boolean m_21532_() {
        return Objects.requireNonNullElseGet(this.builder.isPersistenceRequired, () -> super.m_21532_());
    }

    public double m_142593_(LivingEntity entity) {
        if (this.builder.meleeAttackRangeSqr != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.meleeAttackRangeSqr.apply(this), (String)"double");
            if (obj != null) {
                return (Double)obj;
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for meleeAttackRangeSqr from entity: " + var10000 + ". Value: " + this.builder.meleeAttackRangeSqr.apply(this) + ". Must be a double. Defaulting to " + super.m_142593_(entity)));
            return super.m_142593_(entity);
        }
        return super.m_142593_(entity);
    }

    public int m_8100_() {
        return this.builder.ambientSoundInterval != null ? ((Integer)this.builder.ambientSoundInterval).intValue() : super.m_8100_();
    }

    public double m_6049_() {
        if (this.builder.myRidingOffset == null) {
            return super.m_6049_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.myRidingOffset.apply(this), (String)"double");
        if (obj != null) {
            return (Double)obj;
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for myRidingOffset from entity: " + var10000 + ". Value: " + this.builder.myRidingOffset.apply(this) + ". Must be a double. Defaulting to " + super.m_6049_()));
        return super.m_6049_();
    }

    protected double m_5823_() {
        return Objects.requireNonNullElseGet(this.builder.followLeashSpeed, () -> super.m_5823_());
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        if (this.builder.removeWhenFarAway == null) {
            return super.m_6785_(pDistanceToClosestPlayer);
        }
        ContextUtils.EntityDistanceToPlayerContext context = new ContextUtils.EntityDistanceToPlayerContext(pDistanceToClosestPlayer, (LivingEntity)this);
        Object obj = this.builder.removeWhenFarAway.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for removeWhenFarAway from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6785_(pDistanceToClosestPlayer)));
        return super.m_6785_(pDistanceToClosestPlayer);
    }

    public boolean m_7307_(Entity pEntity) {
        if (this.builder.isAlliedTo != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this);
            Object obj = this.builder.isAlliedTo.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7307_(pEntity)));
        }
        return super.m_7307_(pEntity);
    }

    public void m_7023_(Vec3 pTravelVector) {
        LivingEntity livingentity = this.m_6688_();
        if (this.m_6084_() && this.m_20160_() && this.builder.canSteer.booleanValue() && livingentity != null) {
            if (this.m_6688_() instanceof Player && this.builder.mountJumpingEnabled) {
                if (this.ableToJump()) {
                    this.setThisJumping(true);
                }
                if (this.thisJumping) {
                    this.setThisJumping(false);
                    double jumpPower = this.m_6118_() + this.m_285755_();
                    Vec3 currentVelocity = this.m_20184_();
                    double newVelocityX = currentVelocity.f_82479_;
                    double newVelocityY = currentVelocity.f_82480_ + jumpPower;
                    double newVelocityZ = currentVelocity.f_82481_;
                    this.m_20334_(newVelocityX, newVelocityY, newVelocityZ);
                    this.onJump();
                    ForgeHooks.onLivingJump((LivingEntity)this);
                }
            }
            LivingEntity passenger = this.m_6688_();
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
            this.m_146922_(passenger.m_146908_());
            this.m_146926_(passenger.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float x = passenger.f_20900_ * 0.5f;
            float z = passenger.f_20902_;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            super.m_7023_(new Vec3((double)x, pTravelVector.f_82480_, (double)z));
        } else {
            super.m_7023_(pTravelVector);
        }
        if (this.builder.travel != null) {
            ContextUtils.Vec3Context context = new ContextUtils.Vec3Context(pTravelVector, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.travel, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: travel."));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.builder.tick != null && !this.m_9236_().m_5776_()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.tick, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: tick."));
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.builder.onAddedToWorld != null && !this.m_9236_().m_5776_()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onAddedToWorld, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld."));
        }
    }

    protected void m_6727_(@NotNull LivingEntity target) {
        super.m_6727_(target);
        if (this.builder.doAutoAttackOnTouch != null) {
            ContextUtils.AutoAttackContext context = new ContextUtils.AutoAttackContext((LivingEntity)this, target);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.doAutoAttackOnTouch, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: doAutoAttackOnTouch."));
        }
    }

    protected int m_7302_(int p_21303_) {
        if (this.builder.onDecreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onDecreaseAirSupply, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply."));
        }
        return super.m_7302_(p_21303_);
    }

    protected int m_7305_(int p_21307_) {
        if (this.builder.onIncreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onIncreaseAirSupply, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onIncreaseAirSupply."));
        }
        return super.m_7305_(p_21307_);
    }

    protected void m_6731_(@NotNull LivingEntity p_21246_) {
        super.m_6731_(p_21246_);
        if (this.builder.onBlockedByShield != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, p_21246_);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onBlockedByShield, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply."));
        }
    }

    public void m_238392_(EquipmentSlot slot, ItemStack previous, ItemStack current) {
        super.m_238392_(slot, previous, current);
        if (this.builder.onEquipItem != null) {
            ContextUtils.EntityEquipmentContext context = new ContextUtils.EntityEquipmentContext(slot, previous, current, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEquipItem, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEquipItem."));
        }
    }

    public void m_142540_(@NotNull MobEffectInstance effectInstance, @org.jetbrains.annotations.Nullable Entity entity) {
        if (this.builder.onEffectAdded != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEffectAdded, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectAdded."));
        } else {
            super.m_142540_(effectInstance, entity);
        }
    }

    protected void m_7285_(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.onEffectRemoved != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEffectRemoved, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectRemoved."));
        } else {
            super.m_7285_(effectInstance);
        }
    }

    public void m_5634_(float amount) {
        super.m_5634_(amount);
        if (this.builder.onLivingHeal != null) {
            ContextUtils.EntityHealContext context = new ContextUtils.EntityHealContext((LivingEntity)this, amount);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLivingHeal, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingHeal."));
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.builder.onDeath != null) {
            ContextUtils.DeathContext context = new ContextUtils.DeathContext((LivingEntity)this, damageSource);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onDeath, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onDeath."));
        }
    }

    protected void m_7472_(@NotNull DamageSource damageSource, int lootingMultiplier, boolean allowDrops) {
        if (this.builder.dropCustomDeathLoot != null) {
            ContextUtils.EntityLootContext context = new ContextUtils.EntityLootContext(damageSource, lootingMultiplier, allowDrops, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.dropCustomDeathLoot, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: dropCustomDeathLoot."));
        } else {
            super.m_7472_(damageSource, lootingMultiplier, allowDrops);
        }
    }

    protected void m_142043_() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onFlap, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap."));
        }
        super.m_142043_();
    }

    public boolean ableToJump() {
        return ModKeybinds.mount_jump.m_90857_() && this.m_20096_();
    }

    public void setThisJumping(boolean value) {
        this.thisJumping = value;
    }

    public LivingEntity m_6688_() {
        LivingEntity entity;
        Entity var2 = this.m_146895_();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    @Info(value="Calls a triggerable animation to be played anywhere.\n")
    public void triggerAnimation(String controllerName, String animName) {
        this.triggerAnim(controllerName, animName);
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.CollidingEntityContext context = new ContextUtils.CollidingEntityContext((LivingEntity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7337_(pEntity)));
        }
        return super.m_7337_(pEntity);
    }

    protected float m_6121_() {
        return Objects.requireNonNullElseGet(this.builder.setSoundVolume, () -> Float.valueOf(super.m_6121_())).floatValue();
    }

    protected float m_6108_() {
        return Objects.requireNonNullElseGet(this.builder.setWaterSlowDown, () -> Float.valueOf(super.m_6108_())).floatValue();
    }

    protected float m_20098_() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.m_20098_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), (String)"float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + var10000 + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.m_20098_()));
        return super.m_20098_();
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        if (this.builder != null && this.builder.setStandingEyeHeight != null) {
            ContextUtils.EntityPoseDimensionsContext context = new ContextUtils.EntityPoseDimensionsContext(pPose, pDimensions, (LivingEntity)this);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setStandingEyeHeight.apply(context), (String)"float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setStandingEyeHeight from entity: " + var10000 + ". Value: " + this.builder.setStandingEyeHeight.apply(context) + ". Must be a float. Defaulting to " + super.m_6431_(pPose, pDimensions)));
            return super.m_6431_(pPose, pDimensions);
        }
        return super.m_6431_(pPose, pDimensions);
    }

    public boolean m_6094_() {
        return this.builder.isPushable;
    }

    protected float m_6041_() {
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), (String)"float");
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        Object var10000 = this.builder.get();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + var10000 + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.m_6041_()));
        return super.m_6041_();
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.m_7310_(entity);
        }
        ContextUtils.PassengerEntityContext context = new ContextUtils.PassengerEntityContext(entity, (LivingEntity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_7310_(entity)));
        return super.m_7310_(entity);
    }

    protected boolean m_6125_() {
        if (this.builder.shouldDropLoot != null) {
            Object obj = this.builder.shouldDropLoot.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldDropLoot from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_6125_()));
        }
        return super.m_6125_();
    }

    protected boolean m_6129_() {
        if (this.builder.isAffectedByFluids != null) {
            Object obj = this.builder.isAffectedByFluids.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAffectedByFluids from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6129_()));
        }
        return super.m_6129_();
    }

    protected boolean m_6124_() {
        return this.builder.isAlwaysExperienceDropper;
    }

    protected boolean m_6107_() {
        if (this.builder.isImmobile != null) {
            Object obj = this.builder.isImmobile.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isImmobile from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6107_()));
        }
        return super.m_6107_();
    }

    protected boolean m_142039_() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142039_()));
        }
        return super.m_142039_();
    }

    public int m_5639_(float fallDistance, float pDamageMultiplier) {
        if (this.builder.calculateFallDamage == null) {
            return super.m_5639_(fallDistance, pDamageMultiplier);
        }
        ContextUtils.CalculateFallDamageContext context = new ContextUtils.CalculateFallDamageContext(fallDistance, pDamageMultiplier, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.calculateFallDamage.apply(context), (String)"integer");
        if (obj != null) {
            return (Integer)obj;
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for calculateFallDamage from entity: " + var10000 + ". Value: " + this.builder.calculateFallDamage.apply(context) + ". Must be an int, defaulting to " + super.m_5639_(fallDistance, pDamageMultiplier)));
        return super.m_5639_(fallDistance, pDamageMultiplier);
    }

    protected boolean m_6093_() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.m_6093_());
    }

    protected float m_6059_() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), (String)"float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for nextStep from entity: " + var10000 + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.m_6059_()));
        }
        return super.m_6059_();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        if (this.builder.setHurtSound == null) {
            return super.m_7975_(p_21239_);
        }
        ContextUtils.HurtContext context = new ContextUtils.HurtContext((LivingEntity)this, p_21239_);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setHurtSound.apply(context), (String)"resourcelocation");
        if (obj != null) {
            return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)obj));
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setHurtSound from entity: " + var10000 + ". Value: " + this.builder.setHurtSound.apply(context) + ". Must be a ResourceLocation or String. Defaulting to \"minecraft:entity.generic.hurt\""));
        return super.m_7975_(p_21239_);
    }

    protected SoundEvent m_5509_() {
        return this.builder.setSwimSplashSound == null ? super.m_5509_() : Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent m_5501_() {
        return this.builder.setSwimSound == null ? super.m_5501_() : Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean m_6549_(@NotNull EntityType<?> entityType) {
        if (this.builder.canAttackType != null) {
            ContextUtils.EntityTypeEntityContext context = new ContextUtils.EntityTypeEntityContext((LivingEntity)this, entityType);
            Object obj = this.builder.canAttackType.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAttackType from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6549_(entityType)));
        }
        return super.m_6549_(entityType);
    }

    public float m_6134_() {
        if (this.builder.scale == null) {
            return super.m_6134_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.scale.apply(this), (String)"float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for scale from entity: " + var10000 + ". Value: " + this.builder.scale.apply(this) + ". Must be a float. Defaulting to " + super.m_6134_()));
        return super.m_6134_();
    }

    public boolean m_6149_() {
        if (this.builder.shouldDropExperience != null) {
            Object obj = this.builder.shouldDropExperience.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldDropExperience from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6149_()));
        }
        return super.m_6149_();
    }

    public double m_20968_(@org.jetbrains.annotations.Nullable Entity p_20969_) {
        if (this.builder.visibilityPercent != null) {
            ContextUtils.VisualContext context = new ContextUtils.VisualContext(p_20969_, (LivingEntity)this);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.visibilityPercent.apply(context), (String)"double");
            if (obj != null) {
                return (Double)obj;
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for visibilityPercent from entity: " + var10000 + ". Value: " + this.builder.visibilityPercent.apply(context) + ". Must be a double. Defaulting to " + super.m_20968_(p_20969_)));
            return super.m_20968_(p_20969_);
        }
        return super.m_20968_(p_20969_);
    }

    public boolean m_6779_(@NotNull LivingEntity entity) {
        if (this.builder.canAttack != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, entity);
            Object obj = this.builder.canAttack.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj != false && super.m_6779_(entity);
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAttack from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6779_(entity)));
        }
        return super.m_6779_(entity);
    }

    public boolean m_7301_(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.canBeAffected == null) {
            return super.m_7301_(effectInstance);
        }
        ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
        Object result = this.builder.canBeAffected.apply(context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canBeAffected from entity: " + this.entityName() + ". Value: " + result + ". Must be a boolean. Defaulting to " + super.m_7301_(effectInstance)));
        return super.m_7301_(effectInstance);
    }

    public boolean m_21222_() {
        if (this.builder.invertedHealAndHarm == null) {
            return super.m_21222_();
        }
        Object obj = this.builder.invertedHealAndHarm.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for invertedHealAndHarm from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_21222_()));
        return super.m_21222_();
    }

    protected SoundEvent m_5592_() {
        return this.builder.setDeathSound == null ? super.m_5592_() : Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setDeathSound));
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull @NotNull LivingEntity.Fallsounds m_196493_() {
        return this.builder.fallSounds != null ? new LivingEntity.Fallsounds(Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.smallFallSound)), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.largeFallSound))) : super.m_196493_();
    }

    @NotNull
    public SoundEvent m_7866_(@NotNull ItemStack itemStack) {
        return this.builder.eatingSound != null ? Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.eatingSound)) : super.m_7866_(itemStack);
    }

    public boolean m_6147_() {
        if (this.builder.onClimbable == null) {
            return super.m_6147_();
        }
        Object obj = this.builder.onClimbable.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for onClimbable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to super.onClimbable(): " + super.m_6147_()));
        return super.m_6147_();
    }

    public boolean m_6040_() {
        return Objects.requireNonNullElseGet(this.builder.canBreatheUnderwater, () -> super.m_6040_());
    }

    public boolean m_142535_(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onLivingFall != null) {
            ContextUtils.EntityFallDamageContext context = new ContextUtils.EntityFallDamageContext((LivingEntity)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLivingFall, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall."));
        }
        return super.m_142535_(distance, damageMultiplier, damageSource);
    }

    public void m_6858_(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onSprint, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint."));
        }
        super.m_6858_(sprinting);
    }

    public float m_285755_() {
        if (this.builder.jumpBoostPower == null) {
            return super.m_285755_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.jumpBoostPower.apply(this), (String)"float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for jumpBoostPower from entity: " + var10000 + ". Value: " + this.builder.jumpBoostPower.apply(this) + ". Must be a float. Defaulting to " + super.m_285755_()));
        return super.m_285755_();
    }

    public boolean m_203441_(@NotNull FluidState fluidState) {
        if (this.builder.canStandOnFluid != null) {
            ContextUtils.EntityFluidStateContext context = new ContextUtils.EntityFluidStateContext((LivingEntity)this, fluidState);
            Object obj = this.builder.canStandOnFluid.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canStandOnFluid from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203441_(fluidState)));
        }
        return super.m_203441_(fluidState);
    }

    public boolean m_6126_() {
        if (this.builder.isSensitiveToWater != null) {
            Object obj = this.builder.isSensitiveToWater.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isSensitiveToWater from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6126_()));
        }
        return super.m_6126_();
    }

    public void m_8127_() {
        super.m_8127_();
        if (this.builder.onStopRiding != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStopRiding, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding."));
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.rideTick, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick."));
        }
    }

    public void m_21053_(@NotNull ItemEntity p_21054_) {
        super.m_21053_(p_21054_);
        if (this.builder.onItemPickup != null) {
            ContextUtils.EntityItemEntityContext context = new ContextUtils.EntityItemEntityContext((LivingEntity)this, p_21054_);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onItemPickup, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onItemPickup."));
        }
    }

    public boolean m_142582_(@NotNull Entity entity) {
        if (this.builder.hasLineOfSight != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(entity, (LivingEntity)this);
            Object obj = this.builder.hasLineOfSight.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for hasLineOfSight from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142582_(entity)));
        }
        return super.m_142582_(entity);
    }

    public void m_8108_() {
        if (this.builder.onEnterCombat != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEnterCombat, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEnterCombat."));
        } else {
            super.m_8108_();
        }
    }

    public void m_8098_() {
        if (this.builder.onLeaveCombat != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLeaveCombat, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLeaveCombat."));
        }
        super.m_8098_();
    }

    public boolean m_5801_() {
        if (this.builder.isAffectedByPotions != null) {
            Object obj = this.builder.isAffectedByPotions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAffectedByPotions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5801_()));
        }
        return super.m_5801_();
    }

    public boolean m_5789_() {
        if (this.builder.isAttackable != null) {
            Object obj = this.builder.isAttackable.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5789_()));
        }
        return super.m_5789_();
    }

    public boolean m_7066_(@NotNull ItemStack itemStack) {
        if (this.builder.canTakeItem != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this, itemStack, this.m_9236_());
            Object obj = this.builder.canTakeItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canTakeItem from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7066_(itemStack)));
        }
        return super.m_7066_(itemStack);
    }

    public boolean m_5803_() {
        if (this.builder.isSleeping != null) {
            Object obj = this.builder.isSleeping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isSleeping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5803_()));
        }
        return super.m_5803_();
    }

    public void m_5802_(@NotNull BlockPos blockPos) {
        if (this.builder.onStartSleeping != null) {
            ContextUtils.EntityBlockPosContext context = new ContextUtils.EntityBlockPosContext((LivingEntity)this, blockPos);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStartSleeping, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStartSleeping."));
        }
        super.m_5802_(blockPos);
    }

    public void m_5796_() {
        if (this.builder.onStopSleeping != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStopSleeping, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStopSleeping."));
        }
        super.m_5796_();
    }

    @NotNull
    public ItemStack m_5584_(@NotNull Level level, @NotNull ItemStack itemStack) {
        if (this.builder.eat != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this, itemStack, level);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.eat, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: eat."));
            return itemStack;
        }
        return super.m_5584_(level, itemStack);
    }

    public boolean shouldRiderFaceForward(@NotNull Player player) {
        if (this.builder.shouldRiderFaceForward != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(player, (LivingEntity)this);
            Object obj = this.builder.shouldRiderFaceForward.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldRiderFaceForward from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.shouldRiderFaceForward(player)));
        }
        return super.shouldRiderFaceForward(player);
    }

    public boolean m_142079_() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142079_()));
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203117_()));
        }
        return super.m_203117_();
    }

    public boolean m_142038_() {
        if (this.builder.isCurrentlyGlowing != null && !this.m_9236_().m_5776_()) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142038_()));
        }
        return super.m_142038_();
    }

    public boolean m_213824_() {
        if (this.builder.canDisableShield != null) {
            Object obj = this.builder.canDisableShield.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canDisableShield from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213824_()));
        }
        return super.m_213824_();
    }

    public void m_142036_() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onClientRemoval, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval."));
        }
        super.m_142036_();
    }

    public void m_6475_(DamageSource pDamageSource, float pDamageAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityDamageContext context = new ContextUtils.EntityDamageContext(pDamageSource, pDamageAmount, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHurt, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt."));
        }
        super.m_6475_(pDamageSource, pDamageAmount);
    }

    public void m_20093_() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.lavaHurt, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt."));
        }
        super.m_20093_();
    }

    public int m_213860_() {
        if (this.builder.experienceReward != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.experienceReward.apply(this), (String)"integer");
            if (obj != null) {
                return (Integer)obj;
            }
            String var10000 = this.entityName();
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for experienceReward from entity: " + var10000 + ". Value: " + this.builder.experienceReward.apply(this) + ". Must be an integer. Defaulting to " + super.m_213860_()));
        }
        return super.m_213860_();
    }

    public boolean m_213854_() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213854_()));
        }
        return super.m_213854_();
    }

    public void m_6123_(Player p_20081_) {
        if (this.builder.playerTouch != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(p_20081_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.playerTouch, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch."));
        }
    }

    public boolean m_20152_() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_20152_()));
        }
        return super.m_20152_();
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.m_8038_(p_19927_, p_19928_);
            ContextUtils.ThunderHitContext context = new ContextUtils.ThunderHitContext(p_19927_, p_19928_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.thunderHit, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit."));
        }
    }

    public boolean m_6673_(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.DamageContext context = new ContextUtils.DamageContext((LivingEntity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6673_(p_20122_)));
        }
        return super.m_6673_(p_20122_);
    }

    public boolean m_6072_() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6072_()));
        }
        return super.m_6072_();
    }

    public boolean m_142265_(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.MayInteractContext context = new ContextUtils.MayInteractContext(p_146843_, p_146844_, (LivingEntity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142265_(p_146843_, p_146844_)));
        }
        return super.m_142265_(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.CanTrampleContext context = new ContextUtils.CanTrampleContext(state, pos, fallDistance, (LivingEntity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance)));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public void onRemovedFromWorld() {
        if (this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onRemovedFromWorld, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld."));
        }
        super.onRemovedFromWorld();
    }

    public int m_6056_() {
        if (this.builder.setMaxFallDistance == null) {
            return super.m_6056_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), (String)"integer");
        if (obj != null) {
            return (Integer)obj;
        }
        String var10000 = this.entityName();
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + var10000 + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.m_6056_()));
        return super.m_6056_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (Entity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.lerpTo, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo."));
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return switch (slot.m_20743_()) {
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handItems.get(slot.m_20749_());
            case EquipmentSlot.Type.ARMOR -> (ItemStack)this.armorItems.get(slot.m_20749_());
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        switch (slot.m_20743_()) {
            case HAND: {
                this.m_238392_(slot, (ItemStack)this.handItems.set(slot.m_20749_(), (Object)stack), stack);
                break;
            }
            case ARMOR: {
                this.m_238392_(slot, (ItemStack)this.armorItems.set(slot.m_20749_(), (Object)stack), stack);
            }
        }
    }
}

