/*
 * Decompiled with CFR 0.152.
 */
package net.finallion.nyctophobia.world.biomes;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class DeepDarkForest {
    public static Biome createDeepDarkForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        spawnSettings.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 3));
        spawnSettings.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 10, 3, 5));
        spawnSettings.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20557_, 10, 3, 5));
        spawnSettings.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 3, 5));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        DeepDarkForest.addBasicFeatures(generationSettings);
        DeepDarkForest.addTaigaFeatures(generationSettings);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.7f).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(7180332).m_48043_(4226851).m_48034_(10160412).m_48037_(14159144).m_48019_(12638463).m_48040_(DeepDarkForest.getSkyColor(0.7f)).m_48021_(Musics.f_11651_).m_48023_((Holder)SoundEvents.f_11954_).m_48027_(new AmbientMoodSettings((Holder)SoundEvents.f_12007_, 6000, 8, 2.0)).m_48025_(new AmbientAdditionsSettings((Holder)SoundEvents.f_11901_, 0.0111)).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    private static void addBasicFeatures(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generationSettings);
    }

    private static void addTaigaFeatures(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
    }

    protected static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = Mth.m_14036_((float)f, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }
}

