/*
 * Decompiled with CFR 0.152.
 */
package net.finallion.nyctophobia.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BiomeModification {

    public record ModBiomeModifier(HolderSet<Biome> biomes, GenerationStep.Decoration generationStage, HolderSet<PlacedFeature> features) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)new ResourceLocation("nyctophobia", "biome_modification"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"nyctophobia");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
                BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
                this.features.forEach(holder -> generation.m_255419_(this.generationStage, holder));
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<ModBiomeModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ModBiomeModifier::biomes), (App)Codec.STRING.comapFlatMap(ModBiomeModifier::generationStageFromString, Enum::toString).fieldOf("generation_stage").forGetter(ModBiomeModifier::generationStage), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(ModBiomeModifier::features)).apply((Applicative)builder, ModBiomeModifier::new));
        }

        private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
            try {
                return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Not a decoration stage: " + name);
            }
        }
    }
}

