/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static CompoundTag fromBytes(byte[] bytes) {
        try {
            return NbtIo.m_128939_((InputStream)new DataInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(CompoundTag tag) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(byteStream);
        try {
            NbtIo.m_128947_((CompoundTag)tag, (OutputStream)dataOutput);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteStream.toByteArray();
    }

    public static String hashNbt(CompoundTag tag) {
        MessageDigest digest;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(baos);
        try {
            NbtIo.m_128941_((CompoundTag)tag, (DataOutput)dataOutput);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = baos.toByteArray();
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] hash = digest.digest(bytes);
        return HexFormat.of().formatHex(hash);
    }

    public static String capitalize(ResourceLocation location) {
        String fallback = Utils.capitalize(location.m_135815_());
        if (location.m_135815_().startsWith("block/")) {
            return Component.m_264568_((String)("block." + location.m_135827_() + ".." + location.m_135815_().substring(6)), (String)fallback).getString();
        }
        if (location.m_135815_().startsWith("item/")) {
            return Component.m_264568_((String)("item." + location.m_135827_() + "." + location.m_135815_().substring(5)), (String)fallback).getString();
        }
        return fallback;
    }

    public static String capitalize(String location) {
        return StringUtils.capitalize((String)Utils.replaceUglyChars(location));
    }

    private static String replaceUglyChars(String location) {
        return location.replace(".", " ").replace("/", " ").replace("_", " ");
    }

    public static String beatifyPackID(String s) {
        String[] split = s.replace(".zip", "").split("/");
        return Utils.replaceUglyChars(split[split.length - 1]);
    }

    public static boolean search(String search, String value) {
        if (search.isEmpty()) {
            return true;
        }
        String lowerSearch = Utils.replaceUglyChars(search.toLowerCase());
        String lowerValue = Utils.replaceUglyChars(value.toLowerCase());
        return lowerValue.contains(lowerSearch);
    }
}

