/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.utils.NBTHelper;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class FurnitureData {
    public static final FurnitureData EMPTY = new FurnitureData();
    public String name = "Empty";
    public String tag = "miscellaneous";
    public int lightLevel;
    public int inventorySize;
    public boolean toggleWithRightClick;
    public boolean toggleLight;
    public int contentid = -1;
    public String author = "Unknown";
    public String originalAuthor = "";
    public Set<String> sources = new HashSet<String>();
    public Set<String> dependencies = new HashSet<String>();
    public final List<Element> elements = new LinkedList<Element>();
    public Vector3i size = new Vector3i(1, 1, 1);
    private String hash;
    private final Map<Direction, VoxelShape> cachedShapes = new ConcurrentHashMap<Direction, VoxelShape>();
    private final Map<Integer, VoxelShape> cachedSubShapes = new ConcurrentHashMap<Integer, VoxelShape>();
    private final Set<Direction> requestedShapes = new ConcurrentSkipListSet<Direction>();
    public long lastTick = 0L;

    public FurnitureData() {
        this.elements.add(new Element());
    }

    public FurnitureData(CompoundTag tag) {
        this.name = NBTHelper.getString(tag, "Name", this.name);
        this.tag = NBTHelper.getString(tag, "Tag", this.tag);
        this.lightLevel = NBTHelper.getInt(tag, "LightLevel", this.lightLevel);
        this.inventorySize = NBTHelper.getInt(tag, "InventorySize", this.inventorySize);
        this.toggleWithRightClick = NBTHelper.getBoolean(tag, "ToggleWithRightClick", this.toggleWithRightClick);
        this.toggleLight = NBTHelper.getBoolean(tag, "ToggleLight", this.toggleLight);
        this.contentid = NBTHelper.getInt(tag, "ContentID", this.contentid);
        this.author = NBTHelper.getString(tag, "Author", this.author);
        this.originalAuthor = NBTHelper.getString(tag, "OriginalAuthor", this.originalAuthor);
        this.sources = NBTHelper.getStringSet(tag.m_128437_("Sources", 8));
        this.dependencies = NBTHelper.getStringSet(tag.m_128437_("Dependencies", 8));
        this.size = new Vector3i(NBTHelper.getInt(tag, "SizeX", 1), NBTHelper.getInt(tag, "SizeY", 1), NBTHelper.getInt(tag, "SizeZ", 1));
        ListTag elementsTag = tag.m_128437_("Elements", 10);
        for (int i = 0; i < elementsTag.size(); ++i) {
            this.elements.add(new Element(elementsTag.m_128728_(i)));
        }
    }

    public FurnitureData(FurnitureData data) {
        this.name = data.name;
        this.tag = data.tag;
        this.lightLevel = data.lightLevel;
        this.inventorySize = data.inventorySize;
        this.toggleWithRightClick = data.toggleWithRightClick;
        this.toggleLight = data.toggleLight;
        this.author = data.author;
        this.originalAuthor = data.originalAuthor.isEmpty() ? data.author : data.originalAuthor;
        this.sources.addAll(data.sources);
        this.dependencies.addAll(data.dependencies);
        this.hash = null;
        this.lastTick = 0L;
        for (Element element : data.elements) {
            this.elements.add(new Element(element));
        }
        this.size = new Vector3i(data.size.x, data.size.y, data.size.z);
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", this.name);
        tag.m_128359_("Tag", this.tag);
        tag.m_128405_("LightLevel", this.lightLevel);
        tag.m_128405_("InventorySize", this.inventorySize);
        tag.m_128379_("ToggleWithRightClick", this.toggleWithRightClick);
        tag.m_128379_("ToggleLight", this.toggleLight);
        tag.m_128405_("ContentID", this.contentid);
        tag.m_128359_("Author", this.author);
        tag.m_128359_("OriginalAuthor", this.originalAuthor);
        tag.m_128365_("Sources", (Tag)NBTHelper.getStringList(this.sources));
        tag.m_128365_("Dependencies", (Tag)NBTHelper.getStringList(this.dependencies));
        tag.m_128405_("SizeX", this.size.x);
        tag.m_128405_("SizeY", this.size.y);
        tag.m_128405_("SizeZ", this.size.z);
        ListTag elementsTag = new ListTag();
        for (Element element : this.elements) {
            elementsTag.add((Object)element.toTag());
        }
        tag.m_128365_("Elements", (Tag)elementsTag);
        return tag;
    }

    public int getCost() {
        double volume = Math.sqrt(this.getVolume()) / 32.0;
        double cost = volume + (double)this.inventorySize * 0.5 + (double)this.lightLevel / 15.0 + (double)this.elements.size() / 4.0;
        return (int)Math.ceil(cost * (double)Config.getInstance().costMultiplier);
    }

    public AABB boundingBox() {
        if (this.elements.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Element element : this.elements) {
            if (element.type != ElementType.ELEMENT && element.type != ElementType.SPRITE) continue;
            Vector3f from = element.from;
            Vector3f to = element.to;
            minX = Math.min(minX, from.x);
            minY = Math.min(minY, from.y);
            minZ = Math.min(minZ, from.z);
            maxX = Math.max(maxX, to.x);
            maxY = Math.max(maxY, to.y);
            maxZ = Math.max(maxZ, to.z);
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public int getVolume() {
        int volume = 0;
        for (Element element : this.elements) {
            if (element.type != ElementType.ELEMENT) continue;
            Vector3i size = element.getSize();
            volume += size.x * size.y * size.z;
        }
        return volume;
    }

    public double getSize() {
        AABB boundingBox = this.boundingBox();
        return Math.max(Math.max(Math.abs(boundingBox.f_82288_ - 8.0), Math.abs(boundingBox.f_82289_ - 8.0)), Math.max(Math.max(Math.abs(boundingBox.f_82290_ - 8.0), Math.abs(boundingBox.f_82291_ - 8.0)), Math.max(Math.abs(boundingBox.f_82292_ - 8.0), Math.abs(boundingBox.f_82293_ - 8.0))));
    }

    public boolean requiresBlockEntity() {
        return this.inventorySize > 0;
    }

    public String getHash() {
        if (this.hash == null) {
            this.hash = Utils.hashNbt(this.toTag());
        }
        return this.hash;
    }

    public void dirty() {
        this.hash = null;
        this.cachedShapes.clear();
        this.cachedSubShapes.clear();
        this.requestedShapes.clear();
        for (Element element : this.elements) {
            element.rotationAxes = null;
            element.bakedTexture.clear();
        }
    }

    public void playInteractSound(Level level, BlockPos pos, Player player) {
        for (Element element : this.elements) {
            if (element.type != ElementType.SOUND_EMITTER || !element.soundEmitter.onInteract) continue;
            FurnitureData.playSound(level, pos, player.m_217043_(), element);
        }
    }

    public void emitInteractParticles(BlockPos pos, Direction direction, Player player, ParticleConsumer particleConsumer, boolean inScreen) {
        for (Element element : this.elements) {
            if (element.type != ElementType.PARTICLE_EMITTER || !element.particleEmitter.onInteract) continue;
            this.emitParticles(pos, direction, player.m_217043_(), element, particleConsumer, inScreen, 10.0f);
        }
    }

    public boolean hasParticles() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PARTICLE_EMITTER);
    }

    public boolean hasSounds() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.SOUND_EMITTER);
    }

    public boolean canSit() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PLAYER_POSE && e.playerPose.pose == Pose.SITTING);
    }

    public boolean canSleep() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PLAYER_POSE && e.playerPose.pose == Pose.SLEEPING);
    }

    public List<Component> getTooltip(boolean advanced) {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        tooltip.add((Component)Component.m_237110_((String)"gui.immersive_furniture.author", (Object[])new Object[]{this.author}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (!this.originalAuthor.isEmpty() && !this.originalAuthor.equals(this.author)) {
            tooltip.add((Component)Component.m_237110_((String)"gui.immersive_furniture.original_author", (Object[])new Object[]{this.originalAuthor}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)("gui.immersive_furniture.tag." + this.tag.toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GOLD).m_7220_(this.getPrefixedSizeTooltip()));
        if (this.lightLevel > 0) {
            tooltip.add((Component)Component.m_237110_((String)"gui.immersive_furniture.light_level", (Object[])new Object[]{this.lightLevel}).m_130940_(ChatFormatting.YELLOW));
        }
        if (this.inventorySize > 0) {
            tooltip.add((Component)Component.m_237110_((String)"gui.immersive_furniture.inventory", (Object[])new Object[]{this.inventorySize}).m_130940_(ChatFormatting.YELLOW));
        }
        if (this.hasParticles()) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.has_particles").m_130940_(ChatFormatting.YELLOW));
        }
        if (this.hasSounds()) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.has_sounds").m_130940_(ChatFormatting.YELLOW));
        }
        if (this.canSit()) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.can_sit").m_130940_(ChatFormatting.YELLOW));
        }
        if (this.canSleep()) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.can_sleep").m_130940_(ChatFormatting.YELLOW));
        }
        boolean hasAdvanced = false;
        if (!this.sources.isEmpty()) {
            hasAdvanced = true;
            if (advanced) {
                tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.sources").m_130940_(ChatFormatting.GRAY));
                for (String string : this.sources) {
                    tooltip.add((Component)Component.m_237113_((String)("- " + string)).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (!this.dependencies.isEmpty()) {
            hasAdvanced = true;
            if (advanced) {
                tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.dependencies").m_130940_(ChatFormatting.GRAY));
                for (String string : this.dependencies) {
                    tooltip.add((Component)Component.m_237113_((String)("- " + string)).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (advanced) {
            int pixels = 0;
            for (Element element : this.elements) {
                for (int[] value : element.bakedTexture.values()) {
                    pixels += value.length;
                }
            }
            double d = (double)pixels / Math.pow(DynamicAtlas.BAKED.getSize(), 2.0);
            tooltip.add((Component)Component.m_237110_((String)"gui.immersive_furniture.atlas_usage", (Object[])new Object[]{String.format("%.1f%%", d * 100.0)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (hasAdvanced && !advanced) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_furniture.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        return tooltip;
    }

    private Component getPrefixedSizeTooltip() {
        Component sizeTooltip = this.getSizeTooltip();
        if (sizeTooltip == null) {
            return Component.m_237113_((String)"");
        }
        return Component.m_237113_((String)" - ").m_7220_(sizeTooltip).m_130940_(ChatFormatting.GRAY);
    }

    private Component getSizeTooltip() {
        if (this.size.x == 1 && this.size.y == 1 && this.size.z == 1) {
            return null;
        }
        if (this.size.x == 1 && this.size.y == 1) {
            return Component.m_237110_((String)"gui.immersive_furniture.n_deep", (Object[])new Object[]{this.size.z});
        }
        if (this.size.x == 1 && this.size.z == 1) {
            return Component.m_237110_((String)"gui.immersive_furniture.n_tall", (Object[])new Object[]{this.size.y});
        }
        if (this.size.y == 1 && this.size.z == 1) {
            return Component.m_237110_((String)"gui.immersive_furniture.n_wide", (Object[])new Object[]{this.size.x});
        }
        return Component.m_237113_((String)String.format("%sx%sx%s", this.size.x, this.size.y, this.size.z));
    }

    public PoseOffset getClosestPose(Vec3 location, Direction direction) {
        float bestDistance = Float.MAX_VALUE;
        PoseOffset found = null;
        for (Element element : this.elements) {
            if (element.type != ElementType.PLAYER_POSE) continue;
            Vector3f center = FurnitureData.rotate(element.getRotationAxes().center(), direction).mul(0.0625f);
            double distance = location.m_82531_((double)center.x, (double)center.y, (double)center.z);
            if (found != null && !(distance < (double)bestDistance)) continue;
            bestDistance = (float)distance;
            Vector3f forward = FurnitureData.rotateVector(element.getRotationAxes().forward(), direction).normalize();
            Vector3f up = FurnitureData.rotateVector(element.getRotationAxes().up(), direction).normalize();
            if (element.playerPose.pose == Pose.SLEEPING) {
                center.add((Vector3fc)forward.mul(0.5625f));
                center.sub((Vector3fc)up.mul(-0.0625f));
            } else {
                center.add((Vector3fc)forward.mul(0.125f));
                center.sub((Vector3fc)up.mul(0.03125f));
            }
            found = new PoseOffset(center, element.playerPose.pose, -element.rotation + direction.m_122435_() % 360.0f);
        }
        return found;
    }

    private void emitParticles(BlockPos pos, Direction direction, RandomSource random, Element element, ParticleConsumer particleConsumer, boolean inScreen, float amountMultiplier) {
        SimpleParticleType particle = element.particleEmitter.getParticle();
        if (particle == null) {
            return;
        }
        for (float c = element.particleEmitter.amount * amountMultiplier - random.m_188501_(); c > 0.0f; c -= 1.0f) {
            Vector3f sampledPos = element.sampleRandomPosition(random, direction).mul(0.0625f);
            Vector3f up = new Vector3f((Vector3fc)element.getRotationAxes().up()).div(Math.abs(element.to.y - element.from.y) + 0.001f);
            float vr = element.particleEmitter.velocityRandom / 16.0f;
            float vd = element.particleEmitter.velocityDirectional / 16.0f;
            particleConsumer.addParticle(particle, sampledPos.x() + (inScreen ? 0.0f : (float)pos.m_123341_()), sampledPos.y() + (inScreen ? 1024.0f : (float)pos.m_123342_()), sampledPos.z() + (inScreen ? 0.0f : (float)pos.m_123343_()), (random.m_188501_() - 0.5f) * vr + up.x() * vd, (random.m_188501_() - 0.5f) * vr + up.y() * vd, (random.m_188501_() - 0.5f) * vr + up.z() * vd);
        }
    }

    public void tick(Level level, BlockPos pos, Direction direction, RandomSource random, ParticleConsumer particleConsumer, boolean inScreen, boolean inEditor) {
        for (Element element : this.elements) {
            if (element.type == ElementType.PARTICLE_EMITTER && !element.particleEmitter.onInteract) {
                this.emitParticles(pos, direction, random, element, particleConsumer, inScreen, 1.0f);
                continue;
            }
            if (element.type != ElementType.SOUND_EMITTER || inScreen && !inEditor || !(element.soundEmitter.frequency > 0.0f) || !(random.m_188501_() < element.soundEmitter.frequency)) continue;
            FurnitureData.playSound(level, pos, random, element);
        }
    }

    private static void playSound(Level level, BlockPos pos, RandomSource random, Element element) {
        SoundEvent soundEvent = element.soundEmitter.getSoundEvent();
        if (soundEvent == null) {
            return;
        }
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, (0.75f + random.m_188501_()) * element.soundEmitter.volume, (0.75f + random.m_188501_()) * element.soundEmitter.pitch, false);
    }

    public VoxelShape getShape(Direction rotation) {
        return this.cachedShapes.computeIfAbsent(rotation, this::computeShape);
    }

    public VoxelShape getShape(Direction rotation, int offsetX, int offsetY, int offsetZ) {
        return this.cachedSubShapes.computeIfAbsent(((rotation.ordinal() * 31 + offsetX) * 31 + offsetY) * 31 + offsetZ, key -> this.computeShape(rotation, offsetX, offsetY, offsetZ));
    }

    public VoxelShape getShapeLazy(Direction rotation) {
        if (this.cachedShapes.containsKey(rotation)) {
            return this.cachedShapes.get(rotation);
        }
        if (!this.requestedShapes.contains(rotation)) {
            this.requestedShapes.add(rotation);
            Common.EXECUTOR.execute(() -> this.getShape(rotation));
        }
        return null;
    }

    private VoxelShape computeShape(Direction r) {
        return this.elements.stream().filter(e -> e.type == ElementType.ELEMENT && !e.isFlat()).map(element -> this.getBox((Element)element, r)).reduce((a, b) -> Shapes.m_83148_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_)).map(VoxelShape::m_83296_).orElse(Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
    }

    public int getRotatedX(Direction facing, int x, int z) {
        return switch (facing) {
            case Direction.SOUTH -> -x;
            case Direction.EAST -> -z;
            case Direction.WEST -> z;
            default -> x;
        };
    }

    public int getRotatedZ(Direction facing, int x, int z) {
        return switch (facing) {
            case Direction.SOUTH -> -z;
            case Direction.EAST -> x;
            case Direction.WEST -> -x;
            default -> z;
        };
    }

    public VoxelShape computeShape(Direction rotation, int offsetX, int offsetY, int offsetZ) {
        Vector3f start = FurnitureData.rotate(new Vector3f(offsetX == 0 ? -8.0f : 0.0f, offsetY == 0 ? -8.0f : 0.0f, offsetZ == 0 ? -8.0f : 0.0f), rotation);
        Vector3f stop = FurnitureData.rotate(new Vector3f(offsetX == this.size.x - 1 ? 24.0f : 16.0f, offsetY == this.size.y - 1 ? 24.0f : 16.0f, offsetZ == this.size.z - 1 ? 24.0f : 16.0f), rotation);
        return Shapes.m_83113_((VoxelShape)this.getShape(rotation).m_83216_((double)(-this.getRotatedX(rotation, offsetX, offsetZ)), (double)(-offsetY), (double)(-this.getRotatedZ(rotation, offsetX, offsetZ))), (VoxelShape)Block.m_49796_((double)Math.min(start.x, stop.x), (double)Math.min(start.y, stop.y), (double)Math.min(start.z, stop.z), (double)Math.max(start.x, stop.x), (double)Math.max(start.y, stop.y), (double)Math.max(start.z, stop.z)), (BooleanOp)BooleanOp.f_82689_);
    }

    private static Vector3f rotate(Vector3f vec, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> new Vector3f(16.0f - vec.x, vec.y, 16.0f - vec.z);
            case Direction.EAST -> new Vector3f(16.0f - vec.z, vec.y, vec.x);
            case Direction.WEST -> new Vector3f(vec.z, vec.y, 16.0f - vec.x);
            default -> new Vector3f((Vector3fc)vec);
        };
    }

    private static Vector3f rotateVector(Vector3f vec, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> new Vector3f(-vec.x, vec.y, -vec.z);
            case Direction.EAST -> new Vector3f(-vec.z, vec.y, vec.x);
            case Direction.WEST -> new Vector3f(vec.z, vec.y, -vec.x);
            default -> new Vector3f((Vector3fc)vec);
        };
    }

    private VoxelShape getBox(Element element, Direction rotation) {
        float mid;
        Vector3f[] corners;
        Vector3f from = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vector3f to = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        for (Vector3f corner : corners = ModelUtils.getCorners(element)) {
            from.x = Math.min(from.x, corner.x);
            from.y = Math.min(from.y, corner.y);
            from.z = Math.min(from.z, corner.z);
            to.x = Math.max(to.x, corner.x);
            to.y = Math.max(to.y, corner.y);
            to.z = Math.max(to.z, corner.z);
        }
        double volume = element.getVolume();
        double newVolume = (to.x - from.x) * (to.y - from.y) * (to.z - from.z);
        float fraction = (float)Math.sqrt(volume / newVolume);
        if (element.axis != Direction.Axis.X) {
            mid = 0.5f * (from.x + to.x);
            from.x = from.x * fraction + mid * (1.0f - fraction);
            to.x = to.x * fraction + mid * (1.0f - fraction);
        }
        if (element.axis != Direction.Axis.Y) {
            mid = 0.5f * (from.y + to.y);
            from.y = from.y * fraction + mid * (1.0f - fraction);
            to.y = to.y * fraction + mid * (1.0f - fraction);
        }
        if (element.axis != Direction.Axis.Z) {
            mid = 0.5f * (from.z + to.z);
            from.z = from.z * fraction + mid * (1.0f - fraction);
            to.z = to.z * fraction + mid * (1.0f - fraction);
        }
        Vector3f rotatedFrom = FurnitureData.rotate(from, rotation);
        Vector3f rotatedTo = FurnitureData.rotate(to, rotation);
        float resolution = this.elements.size() > 96 ? 1.0f : (this.elements.size() > 48 ? 2.0f : 4.0f);
        return Block.m_49796_((double)((float)Math.round(Math.min(rotatedFrom.x, rotatedTo.x) * resolution) / resolution), (double)((float)Math.round(Math.min(rotatedFrom.y, rotatedTo.y) * resolution) / resolution), (double)((float)Math.round(Math.min(rotatedFrom.z, rotatedTo.z) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.x, rotatedTo.x) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.y, rotatedTo.y) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.z, rotatedTo.z) * resolution) / resolution));
    }

    public static class Element {
        public Vector3f from;
        public Vector3f to;
        public Direction.Axis axis = Direction.Axis.Y;
        public float rotation = 0.0f;
        public ElementType type = ElementType.ELEMENT;
        public int color = -1;
        public int emission = 0;
        public Material material;
        public ParticleEmitter particleEmitter;
        public SoundEmitter soundEmitter;
        public PlayerPose playerPose;
        public Sprite sprite;
        public Map<Direction, int[]> bakedTexture = new ConcurrentHashMap<Direction, int[]>();
        public ElementRotationAxes rotationAxes;

        public Element() {
            this.from = new Vector3f(2.0f, 0.0f, 2.0f);
            this.to = new Vector3f(14.0f, 12.0f, 14.0f);
            this.material = new Material();
            this.particleEmitter = new ParticleEmitter();
            this.soundEmitter = new SoundEmitter();
            this.playerPose = new PlayerPose();
            this.sprite = new Sprite();
        }

        public Element(CompoundTag tag) {
            this.from = NBTHelper.getVector3f(tag.m_128437_("From", 5));
            this.to = NBTHelper.getVector3f(tag.m_128437_("To", 5));
            this.axis = NBTHelper.getEnum(tag, Direction.Axis.class, "Axis", this.axis);
            this.rotation = NBTHelper.getFloat(tag, "Rotation", this.rotation);
            this.type = NBTHelper.getEnum(tag, ElementType.class, "Type", this.type);
            this.color = NBTHelper.getInt(tag, "Color", this.color);
            this.emission = NBTHelper.getInt(tag, "Emission", 0);
            this.material = new Material(tag.m_128469_("Material"));
            this.particleEmitter = new ParticleEmitter(tag.m_128469_("ParticleEmitter"));
            this.soundEmitter = new SoundEmitter(tag.m_128469_("SoundEmitter"));
            this.playerPose = new PlayerPose(tag.m_128469_("PlayerPose"));
            this.sprite = new Sprite(tag.m_128469_("Sprite"));
            CompoundTag bakedTextureTag = tag.m_128469_("BakedTexture");
            for (String key : bakedTextureTag.m_128431_()) {
                this.bakedTexture.put((Direction)Direction.f_175356_.m_216455_(key), bakedTextureTag.m_128465_(key));
            }
        }

        public Element(Element element) {
            this.from = new Vector3f((Vector3fc)element.from);
            this.to = new Vector3f((Vector3fc)element.to);
            this.axis = element.axis;
            this.rotation = element.rotation;
            this.type = element.type;
            this.color = element.color;
            this.emission = element.emission;
            this.material = new Material(element.material);
            this.particleEmitter = new ParticleEmitter(element.particleEmitter);
            this.soundEmitter = new SoundEmitter(element.soundEmitter);
            this.playerPose = new PlayerPose(element.playerPose);
            this.sprite = new Sprite(element.sprite);
            this.bakedTexture = new ConcurrentHashMap<Direction, int[]>();
            this.rotationAxes = null;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("From", (Tag)NBTHelper.getFloatList(this.from));
            tag.m_128365_("To", (Tag)NBTHelper.getFloatList(this.to));
            tag.m_128359_("Axis", this.axis.m_7912_());
            tag.m_128350_("Rotation", this.rotation);
            tag.m_128359_("Type", this.type.name().toLowerCase());
            tag.m_128405_("Color", this.color);
            tag.m_128405_("Emission", this.emission);
            if (this.type == ElementType.ELEMENT) {
                tag.m_128365_("Material", (Tag)this.material.toTag());
                CompoundTag bakedTextureTag = new CompoundTag();
                for (Map.Entry<Direction, int[]> entry : this.bakedTexture.entrySet()) {
                    bakedTextureTag.m_128385_(entry.getKey().m_7912_(), entry.getValue());
                }
                tag.m_128365_("BakedTexture", (Tag)bakedTextureTag);
            } else if (this.type == ElementType.PARTICLE_EMITTER) {
                tag.m_128365_("ParticleEmitter", (Tag)this.particleEmitter.toTag());
            } else if (this.type == ElementType.SOUND_EMITTER) {
                tag.m_128365_("SoundEmitter", (Tag)this.soundEmitter.toTag());
            } else if (this.type == ElementType.PLAYER_POSE) {
                tag.m_128365_("PlayerPose", (Tag)this.playerPose.toTag());
            } else if (this.type == ElementType.SPRITE) {
                tag.m_128365_("Sprite", (Tag)this.sprite.toTag());
            }
            return tag;
        }

        public Vector3i getSize() {
            return new Vector3i(Math.abs((int)(this.to.x - this.from.x)), Math.abs((int)(this.to.y - this.from.y)), Math.abs((int)(this.to.z - this.from.z)));
        }

        public float getVolume() {
            Vector3i size = this.getSize();
            return size.x * size.y * size.z;
        }

        public Vector3f getCenter() {
            return new Vector3f((this.from.x + this.to.x) / 2.0f, (this.from.y + this.to.y) / 2.0f, (this.from.z + this.to.z) / 2.0f);
        }

        public ElementRotation getRotation() {
            return new ElementRotation(this.getOrigin(), this.axis, this.rotation, false);
        }

        public Vector3f getOrigin() {
            return new Vector3f((this.from.x + this.to.x) / 32.0f, (this.from.y + this.to.y) / 32.0f, (this.from.z + this.to.z) / 32.0f);
        }

        public void sanityCheck() {
            if (this.type == ElementType.PLAYER_POSE) {
                Vector3f center = this.getCenter();
                this.from.x = center.x - 4.0f;
                this.from.y = center.y - 1.0f;
                this.from.z = center.z - (this.playerPose.pose == Pose.SLEEPING ? 14.0f : 4.0f);
                this.to.x = center.x + 4.0f;
                this.to.y = center.y + 1.0f;
                this.to.z = center.z + (this.playerPose.pose == Pose.SLEEPING ? 14.0f : 4.0f);
                this.axis = Direction.Axis.Y;
            } else if (this.type == ElementType.SPRITE) {
                Vector3f center = this.getCenter();
                if (!this.sprite.tiled) {
                    this.from.x = center.x - 8.0f * this.sprite.size;
                    this.from.y = center.y - 8.0f * this.sprite.size;
                    this.to.x = center.x + 8.0f * this.sprite.size;
                    this.to.y = center.y + 8.0f * this.sprite.size;
                }
                this.to.z = this.from.z;
            } else if (this.type == ElementType.ELEMENT) {
                this.color = -1;
            }
            this.from.x = (float)Math.round(this.from.x * 64.0f) / 64.0f;
            this.from.y = (float)Math.round(this.from.y * 64.0f) / 64.0f;
            this.from.z = (float)Math.round(this.from.z * 64.0f) / 64.0f;
            this.to.x = (float)Math.round(this.to.x - this.from.x) + this.from.x;
            this.to.y = (float)Math.round(this.to.y - this.from.y) + this.from.y;
            this.to.z = (float)Math.round(this.to.z - this.from.z) + this.from.z;
        }

        public boolean contains(Vector3f pos) {
            return this.contains(pos, 1.0E-4f);
        }

        public boolean contains(Vector3f pos, float margin) {
            return pos.x >= this.from.x - margin && pos.x <= this.to.x + margin && pos.y >= this.from.y - margin && pos.y <= this.to.y + margin && pos.z >= this.from.z - margin && pos.z <= this.to.z + margin;
        }

        public void move(float x, float y, float z) {
            this.from.add(x, y, z);
            this.to.add(x, y, z);
        }

        public ElementRotationAxes getRotationAxes() {
            if (this.rotationAxes == null) {
                this.rotationAxes = new ElementRotationAxes(this.getCenter(), this.getSize());
                ElementRotation elementRotation = this.getRotation();
                Quaternionf quaternion = ModelUtils.getElementRotation(elementRotation);
                quaternion.transform(this.rotationAxes.up);
                quaternion.transform(this.rotationAxes.right);
                quaternion.transform(this.rotationAxes.forward);
                ModelUtils.applyElementRotation(this.rotationAxes.center, elementRotation);
            }
            return this.rotationAxes;
        }

        public Vector3f sampleRandomPosition(RandomSource random, Direction direction) {
            ElementRotationAxes axes = this.getRotationAxes();
            float x = random.m_188501_() - 0.5f;
            float y = random.m_188501_() - 0.5f;
            float z = random.m_188501_() - 0.5f;
            Vector3f pos = new Vector3f(axes.center.x + x * axes.right.x + y * axes.up.x + z * axes.forward.x, axes.center.y + x * axes.right.y + y * axes.up.y + z * axes.forward.y, axes.center.z + x * axes.right.z + y * axes.up.z + z * axes.forward.z);
            if (direction != null) {
                return FurnitureData.rotate(pos, direction);
            }
            return pos;
        }

        public Vector3f getGlobalDirectionNormal(Direction direction) {
            return ModelUtils.rotate(direction.m_253071_(), this.axis, this.rotation);
        }

        public boolean isFlat() {
            return this.from.x == this.to.x || this.from.y == this.to.y || this.from.z == this.to.z;
        }
    }

    public static enum ElementType {
        ELEMENT,
        PARTICLE_EMITTER,
        SOUND_EMITTER,
        PLAYER_POSE,
        SPRITE;

    }

    public record ElementRotationAxes(Vector3f center, Vector3f right, Vector3f up, Vector3f forward) {
        public ElementRotationAxes(Vector3f center, Vector3i size) {
            this(center, new Vector3f((float)size.x(), 0.0f, 0.0f), new Vector3f(0.0f, (float)size.y(), 0.0f), new Vector3f(0.0f, 0.0f, (float)size.z()));
        }
    }

    public static class SoundEmitter {
        public ResourceLocation sound = new ResourceLocation("minecraft:entity.item.pickup");
        public float volume = 1.0f;
        public float pitch = 1.0f;
        public float frequency = 0.1f;
        public boolean onInteract = false;

        public SoundEmitter() {
        }

        public SoundEmitter(CompoundTag tag) {
            this.sound = NBTHelper.getResourceLocation(tag, "Sound", this.sound);
            this.volume = NBTHelper.getFloat(tag, "Volume", this.volume);
            this.pitch = NBTHelper.getFloat(tag, "Pitch", this.pitch);
            this.frequency = NBTHelper.getFloat(tag, "Frequency", this.frequency);
            this.onInteract = NBTHelper.getBoolean(tag, "OnInteract", this.onInteract);
        }

        public SoundEmitter(SoundEmitter soundEmitter) {
            this.sound = soundEmitter.sound;
            this.volume = soundEmitter.volume;
            this.pitch = soundEmitter.pitch;
            this.frequency = soundEmitter.frequency;
            this.onInteract = soundEmitter.onInteract;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Sound", this.sound.toString());
            tag.m_128350_("Volume", this.volume);
            tag.m_128350_("Pitch", this.pitch);
            tag.m_128350_("Frequency", this.frequency);
            tag.m_128379_("OnInteract", this.onInteract);
            return tag;
        }

        public SoundEvent getSoundEvent() {
            return (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(this.sound);
        }
    }

    public static class ParticleEmitter {
        public ResourceLocation particle = new ResourceLocation("minecraft:smoke");
        public float velocityDirectional = 0.0f;
        public float velocityRandom = 0.1f;
        public float amount = 0.5f;
        public boolean onInteract = false;

        public ParticleEmitter() {
        }

        public ParticleEmitter(CompoundTag tag) {
            this.particle = NBTHelper.getResourceLocation(tag, "Particle", this.particle);
            this.velocityDirectional = NBTHelper.getFloat(tag, "VelocityDirectional", this.velocityDirectional);
            this.velocityRandom = NBTHelper.getFloat(tag, "VelocityRandom", this.velocityRandom);
            this.amount = NBTHelper.getFloat(tag, "Amount", this.amount);
            this.onInteract = NBTHelper.getBoolean(tag, "OnInteract", this.onInteract);
        }

        public ParticleEmitter(ParticleEmitter particleEmitter) {
            this.particle = particleEmitter.particle;
            this.velocityDirectional = particleEmitter.velocityDirectional;
            this.velocityRandom = particleEmitter.velocityRandom;
            this.amount = particleEmitter.amount;
            this.onInteract = particleEmitter.onInteract;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Particle", this.particle.toString());
            tag.m_128350_("VelocityDirectional", this.velocityDirectional);
            tag.m_128350_("VelocityRandom", this.velocityRandom);
            tag.m_128350_("Amount", this.amount);
            tag.m_128379_("OnInteract", this.onInteract);
            return tag;
        }

        public SimpleParticleType getParticle() {
            Object object = BuiltInRegistries.f_257034_.m_7745_(this.particle);
            if (object instanceof SimpleParticleType) {
                SimpleParticleType simpleParticleType = (SimpleParticleType)object;
                return simpleParticleType;
            }
            return null;
        }
    }

    public static interface ParticleConsumer {
        public void addParticle(SimpleParticleType var1, float var2, float var3, float var4, float var5, float var6, float var7);
    }

    public static class PlayerPose {
        public Pose pose = Pose.SITTING;

        public PlayerPose() {
        }

        public PlayerPose(CompoundTag tag) {
            this.pose = NBTHelper.getEnum(tag, Pose.class, "Pose", this.pose);
        }

        public PlayerPose(PlayerPose playerPose) {
            this.pose = playerPose.pose;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Pose", this.pose.name());
            return tag;
        }
    }

    public record PoseOffset(Vector3f offset, Pose pose, float rotation) {
    }

    public static class LightMaterialEffect {
        public float roundness = 0.0f;
        public float brightness = 0.0f;
        public float contrast = 0.0f;
        public float hue = 0.0f;
        public float saturation = 0.0f;
        public float value = 0.0f;

        public LightMaterialEffect() {
        }

        public LightMaterialEffect(LightMaterialEffect lightEffect) {
            this.roundness = lightEffect.roundness;
            this.brightness = lightEffect.brightness;
            this.contrast = lightEffect.contrast;
            this.hue = lightEffect.hue;
            this.saturation = lightEffect.saturation;
            this.value = lightEffect.value;
        }

        public void load(CompoundTag tag) {
            this.roundness = NBTHelper.getFloat(tag, "Roundness", this.roundness);
            this.brightness = NBTHelper.getFloat(tag, "Brightness", this.brightness);
            this.contrast = NBTHelper.getFloat(tag, "Contrast", this.contrast);
            this.hue = NBTHelper.getFloat(tag, "Hue", this.hue);
            this.saturation = NBTHelper.getFloat(tag, "Saturation", this.saturation);
            this.value = NBTHelper.getFloat(tag, "Value", this.value);
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("Roundness", this.roundness);
            tag.m_128350_("Brightness", this.brightness);
            tag.m_128350_("Contrast", this.contrast);
            tag.m_128350_("Hue", this.hue);
            tag.m_128350_("Saturation", this.saturation);
            tag.m_128350_("Value", this.value);
            return tag;
        }
    }

    public static class Sprite {
        public ResourceLocation sprite = new ResourceLocation("minecraft:block/soul_fire_1");
        public int rotation = 0;
        public float size = 1.0f;
        public boolean tiled = false;

        public Sprite() {
        }

        public Sprite(CompoundTag tag) {
            this.sprite = NBTHelper.getResourceLocation(tag, "Sprite", this.sprite);
            this.rotation = NBTHelper.getInt(tag, "Rotation", this.rotation);
            this.size = NBTHelper.getFloat(tag, "Size", this.size);
            this.tiled = NBTHelper.getBoolean(tag, "Tiled", this.tiled);
        }

        public Sprite(Sprite sprite) {
            this.sprite = sprite.sprite;
            this.rotation = sprite.rotation;
            this.size = sprite.size;
            this.tiled = sprite.tiled;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Sprite", this.sprite.toString());
            tag.m_128405_("Rotation", this.rotation);
            tag.m_128350_("Size", this.size);
            tag.m_128379_("Tiled", this.tiled);
            return tag;
        }
    }

    public static class Material {
        public ResourceLocation source = new ResourceLocation("minecraft:oak_log");
        public int margin = 4;
        public WrapMode wrap = WrapMode.EXPAND;
        public MaterialAxis axis = MaterialAxis.X;
        public TransparencyType transparency = TransparencyType.SOLID;
        public LightMaterialEffect lightEffect = new LightMaterialEffect();

        public Material() {
        }

        public Material(CompoundTag tag) {
            this.source = NBTHelper.getResourceLocation(tag, "Source", this.source);
            this.margin = NBTHelper.getInt(tag, "Margin", this.margin);
            this.wrap = NBTHelper.getEnum(tag, WrapMode.class, "Wrap", this.wrap);
            this.axis = NBTHelper.getEnum(tag, MaterialAxis.class, "Axis", this.axis);
            this.transparency = NBTHelper.getEnum(tag, TransparencyType.class, "Transparency", this.transparency);
            this.lightEffect.load(tag.m_128469_("LightEffect"));
        }

        public Material(Material material) {
            this.source = material.source;
            this.margin = material.margin;
            this.wrap = material.wrap;
            this.axis = material.axis;
            this.transparency = material.transparency;
            this.lightEffect = new LightMaterialEffect(material.lightEffect);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Source", this.source.toString());
            tag.m_128405_("Margin", this.margin);
            tag.m_128359_("Wrap", this.wrap.name());
            tag.m_128359_("Axis", this.axis.name());
            tag.m_128359_("Transparency", this.transparency.name());
            tag.m_128365_("LightEffect", (Tag)this.lightEffect.save());
            return tag;
        }
    }

    public static enum MaterialAxis {
        X,
        Y,
        Z;

    }

    public static enum WrapMode {
        EXPAND,
        REPEAT;

    }
}

